dnl= ##########################################################################
dnl= # abiword-plugins: autogen.sh header
dnl= # this file is executed as a shell script
dnl= 
dnl= # 1. abi_plugin_macro is the name of the main macro defined here:
dnl= abi_plugin_macro="ABIPGN_ABICOLLAB"
dnl= abi_plugin_macro_init="ABIPGN_ABICOLLAB_INIT"
dnl= abi_plugin_macro_end="ABIPGN_ABICOLLAB_END"
dnl= 
dnl= # 2. abi_plugin_files is the list of files that configure must generate:
dnl= abi_plugin_files="GNUmakefile core/GNUmakefile core/dialogs/GNUmakefile core/dialogs/xp/GNUmakefile core/dialogs/unix/GNUmakefile core/dialogs/win/GNUmakefile core/packet/GNUmakefile core/packet/xp/GNUmakefile core/session/GNUmakefile core/session/xp/GNUmakefile backends/GNUmakefile backends/xmpp/GNUmakefile backends/xmpp/xp/GNUmakefile backends/xmpp/unix/GNUmakefile backends/tcp/GNUmakefile backends/tcp/xp/GNUmakefile backends/tcp/unix/GNUmakefile backends/tcp/win/GNUmakefile backends/sugar/GNUmakefile backends/sugar/unix/GNUmakefile backends/fake/GNUmakefile backends/fake/xp/GNUmakefile backends/service/GNUmakefile backends/service/xp/GNUmakefile backends/service/unix/GNUmakefile backends/xp/GNUmakefile"
dnl= 
dnl= # 3. abi_plugin_desc is a short description of the plugin
dnl= abi_plugin_desc="Real-time collaborative editing"
dnl=
dnl= # 4. abi_plugin_enable - whether plugin should be enabled by default 
dnl= abi_plugin_enable="yes"
dnl=
dnl= return
dnl= ##########################################################################

AC_DEFUN([ABIPGN_ABICOLLAB_INIT],[

abicollab_handler_fake=no
abicollab_handler_xmpp=no
abicollab_handler_tcp=no
abicollab_handler_sugar=no
abicollab_handler_service=no

abicollab_record_always=no

])

AC_DEFUN([ABIPGN_ABICOLLAB],[
_abi_cppflags_save="$CPPFLAGS"
_abi_ldflags_save="$LDFLAGS"

ABICOLLAB_LIBXML2_CPPFLAGS=""
ABICOLLAB_LIBXML2_LIBS=""

ABICOLLAB_FAKE_CPPFLAGS=""
ABICOLLAB_FAKE_LIBS=""

ABICOLLAB_XMPP_CPPFLAGS=""
ABICOLLAB_XMPP_LIBS=""

ABICOLLAB_TCP_CPFLAGS=""
ABICOLLAB_TCP_LIBS=""

ABICOLLAB_SUGAR_CPFLAGS=""
ABICOLLAB_SUGAR_LIBS=""

ABICOLLAB_SERVICE_CPFLAGS=""
ABICOLLAB_SERVICE_LIBS=""


#
# General checks
#

if test x$abi_platform != "xcocoa"; then

# check for libxml2
PKG_CHECK_MODULES(_abi_libxml2,[libxml-2.0 >= 2.4.0],[
	ABI_PLUGIN_REPORT([abicollab: okay])
],[	ABI_PLUGIN_REPORT([abicollab: error, libxml-2.0 >= 2.4.0 required])
	abi_plugin_disable=yes
])
if test "x$abi_plugin_disable" = "xno"; then
	ABICOLLAB_LIBXML2_CPPFLAGS="$_abi_libxml2_CFLAGS"
	ABICOLLAB_LIBXML2_LIBS="$_abi_libxml2_LIBS"
fi
AC_SUBST(ABICOLLAB_LIBXML2_CPPFLAGS)
AC_SUBST(ABICOLLAB_LIBXML2_LIBS)

# check for various boost libs
AX_BOOST_BASE([1.33.1])

# check for asio
AC_LANG_PUSH(C++)
ABICOLLAB_ASIO_CFLAGS=""
ABICOLLAB_ASIO_DIR=""
AC_ARG_WITH(asio,[  --with-asio=DIR       use ASIO in DIR],[
	ABICOLLAB_ASIO_DIR="$withval"
	asio_dir=yes
],[
	asio_dir=auto
])
if test "x$asio_dir" = "xyes"; then
	ABICOLLAB_ASIO_CPPFLAGS="-I$ABICOLLAB_ASIO_DIR/include"
fi


#
# Checks for Fake support (for debugging purposes only)
#
AC_ARG_ENABLE(abicollab-fake-backend,[  --enable-abicollab-fake-backend    AbiCollab Fake backend (default: no, for debugging purposes only)],[
	if [ test "x$enableval" != "xno" ]; then
        	abicollab_handler_fake=yes
		ABI_PLUGIN_REPORT([abicollab Fake support: yes])
        fi
])
if [ test $abicollab_handler_fake = yes ]; then
	ABICOLLAB_FAKE_CPPFLAGS="-DABICOLLAB_HANDLER_FAKE"
fi
AC_SUBST(ABICOLLAB_FAKE_CPPFLAGS)
AC_SUBST(ABICOLLAB_FAKE_LIBS)

#
# Checks for XMPP support (using loudmouth)
#
PKG_CHECK_MODULES(_abi_loudmouth,[loudmouth-1.0 >= 1.0.1 ],[
	ABI_PLUGIN_REPORT([abicollab XMPP support: yes])
	abicollab_handler_xmpp=yes
],[	ABI_PLUGIN_REPORT([abicollab XMPP support: no, loudmouth >= 1.0.1 required])
])
if test "x$abicollab_handler_xmpp" = "xyes"; then
	ABICOLLAB_XMPP_CPPFLAGS="$_abi_loudmouth_CFLAGS -DABICOLLAB_HANDLER_XMPP"
	ABICOLLAB_XMPP_LIBS="$_abi_loudmouth_LIBS"
fi
AC_SUBST(ABICOLLAB_XMPP_CPPFLAGS)
AC_SUBST(ABICOLLAB_XMPP_LIBS)


#
# Checks for TCP support (using asio)
#
CPPFLAGS="$CPPFLAGS $ABICOLLAB_ASIO_CPPFLAGS"
AC_CHECK_HEADERS(asio.hpp,[
	ABI_PLUGIN_REPORT([abicollab TCP support: yes]) 
	abicollab_handler_tcp=yes
],[	ABI_PLUGIN_REPORT([abicollab TCP support: no, asio >= 0.3.8rc1 required])
])
if test "x$abicollab_handler_tcp" = "xyes" ; then
	ABICOLLAB_TCP_CPPFLAGS="-DABICOLLAB_HANDLER_TCP $ABICOLLAB_ASIO_CPPFLAGS"
	ABICOLLAB_TCP_LIBS="-lpthread"
fi
CPPFLAGS="$_abi_cppflags_save"
LDFLAGS="$_abi_ldflags_save"
AC_SUBST(ABICOLLAB_TCP_CPPFLAGS)
AC_SUBST(ABICOLLAB_TCP_LIBS)
AC_LANG_POP

CPPFLAGS="$_abi_cppflags_save"
LDFLAGS="$_abi_ldflags_save"


#
# Checks for Sugar
#
AC_ARG_WITH(abicollab-sugar-backend,[  --with-abicollab-sugar-backend       enable the Sugar backend for abicollab],[
	PKG_CHECK_MODULES(_abi_dbus,[dbus-1 >= 1.0.1 ],[
		ABI_PLUGIN_REPORT([abicollab Sugar support: yes])
		abicollab_handler_sugar=yes
	],[	ABI_PLUGIN_REPORT([abicollab Sugar support: no, dbus-1 >= 1.0.1 required])
		abicollab_handler_sugar=no
	])

	if test "x$abicollab_handler_sugar" = "xyes" ; then
		PKG_CHECK_MODULES(_abi_dbus_glib,[dbus-glib-1 >= 0.70 ],[
			ABI_PLUGIN_REPORT([abicollab Sugar support: yes])
			abicollab_handler_sugar=yes
		],[	ABI_PLUGIN_REPORT([abicollab Sugar support: no, dbus-glib-1 >= 0.70 required])
			abicollab_handler_sugar=no
		])
	fi

],[
	ABI_PLUGIN_REPORT([abicollab Sugar support: no])
	abicollab_handler_sugar=no
])
if test "x$abicollab_handler_sugar" = "xyes" ; then
	ABICOLLAB_SUGAR_CPPFLAGS="$_abi_dbus_CFLAGS $_abi_dbus_glib_CFLAGS -DABICOLLAB_HANDLER_SUGAR"
	ABICOLLAB_SUGAR_LIBS="$_abi_dbus_LIBS $_abi_dbus_glib_LIBS"
fi
AC_SUBST(ABICOLLAB_SUGAR_CPPFLAGS)
AC_SUBST(ABICOLLAB_SUGAR_LIBS)


#
# Checks for the abicollab.net service backend
#
AC_ARG_WITH(abicollab-service-backend,[  --with-abicollab-service-backend       enable the abicollab.net service backend for abicollab; NOTE to packagers: do NOT enable this, the service is not publically available yet],[
	AC_CHECK_HEADERS(asio.hpp,[
		abicollab_handler_service=yes
	],[	ABI_PLUGIN_REPORT([abicollab abicollab.net support: no, asio >= 0.3.8rc1 required])
	])
	
	if test "x$abicollab_handler_service" = "xyes" ; then
		PKG_CHECK_MODULES(ABICOLLAB_SOUP, [libsoup-2.2 >= 2.2.100],[
			ABI_PLUGIN_REPORT([abicollab abicollab.net support: yes])
		        abicollab_handler_service=yes
		],[	PKG_CHECK_MODULES(ABICOLLAB_SOUP, [libsoup-2.4 >= 2.4.1],[
				ABICOLLAB_SOUP_CFLAGS+=-DSOUP24
				ABI_PLUGIN_REPORT([abicollab abicollab.net support: yes])
				abicollab_handler_service=yes
			],[
				ABI_PLUGIN_REPORT([abicollab abicollab.net support: no, libsoup-2.2 >= 2.2.100 or libsoup-2.4 >= 2.4.1 required])
				abicollab_handler_service=no
			])
		])
	fi
	
],[
	ABI_PLUGIN_REPORT([abicollab abicollab.net support: no])
	abicollab_handler_service=no
])
if test "x$abicollab_handler_service" = "xyes" ; then
	ABICOLLAB_SERVICE_CPPFLAGS="-DABICOLLAB_HANDLER_SERVICE $ABICOLLAB_ASIO_CPPFLAGS $ABICOLLAB_SOUP_CFLAGS"
	ABICOLLAB_SERVICE_LIBS="-lpthread $ABICOLLAB_SOUP_LIBS"
fi
AC_SUBST(ABICOLLAB_SERVICE_CPPFLAGS)
AC_SUBST(ABICOLLAB_SERVICE_LIBS)

#
# Record functionality
#
AC_ARG_ENABLE(abicollab-record-always,[  --enable-abicollab-record-always    Always record AbiCollab sessions (default: no)],[
	if [ test "x$enableval" != "xno" ]; then
        	abicollab_record_always=yes
		ABI_PLUGIN_REPORT([ ** enabling auto-recording of abicollab sessions ** ])
        fi
])
if [ test $abicollab_record_always = yes ]; then
	CPPFLAGS="$CPPFLAGS -DABICOLLAB_RECORD_ALWAYS"
fi

else
	abi_plugin_disable=yes
        ABI_PLUGIN_REPORT([abicollab: disabled on Cocoa])
fi

]) # end AC_DEFUN([ABIPGN_ABICOLLAB], ...)


AC_DEFUN([ABIPGN_ABICOLLAB_END],[

AM_CONDITIONAL(ABICOLLAB_HANDLER_FAKE, test "x$abicollab_handler_fake" = "xyes")
AM_CONDITIONAL(ABICOLLAB_HANDLER_XMPP, test "x$abicollab_handler_xmpp" = "xyes")
AM_CONDITIONAL(ABICOLLAB_HANDLER_TCP, test "x$abicollab_handler_tcp" = "xyes")
AM_CONDITIONAL(ABICOLLAB_HANDLER_SUGAR, test "x$abicollab_handler_sugar" = "xyes")
AM_CONDITIONAL(ABICOLLAB_HANDLER_SERVICE, test "x$abicollab_handler_service" = "xyes")

])

