#!/bin/bash

#prevent acpid from processing any following events
touch /var/lock/acpisleep

# Unload PCMCIA cards
cardctl eject

# Stop IRDA if it's running
if [ -f /var/run/irattach.pid ]; then
    /etc/init.d/irda-utils stop
    killall -9 irattach
fi

for x in /sys/module/*_ircc /sys/module/*_ircc2; do
    rmmod `basename $x` 2>/dev/null;
done

if [ -d /sys/module/ndiswrapper ]; then
	rmmod ndiswrapper
	MODULES="$MODULES ndiswrapper"
fi

# Find the currently running network interfaces...
INTERFACES=`/sbin/ifconfig | awk '/^[^ ]+/ {print $1}'`

# And shut them down
for x in $INTERFACES; do
    ifdown $x;
    ifconfig $x down;
done

# This is not guaranteed to work - several drivers appear to use names that
# are not the same as their module name
for x in /sys/class/net/*; do
    if [ -e $x/device/driver ]
	then	
	MODULES="$MODULES $(basename $(readlink $x/device/driver) | tr [:upper:] [:lower:])"
    fi
done

# Now do something similar for USB
for x in /sys/class/usb_host/*; do
    if [ -e $x/device/driver ]
	then
	MODULES="$MODULES $(basename $(readlink $x/device/driver) | tr [:upper:] [:lower:])"
    fi
done

# And input devices. Hmm, this actually seems to break more than it fixes.
#for x in /sys/class/input/*; do
#    if [ -e $x/device/driver ]
#	then
#	MODULES="$MODULES $(basename $(readlink $x/device/driver) | tr [:upper:] [:lower:])"
#    fi
#done

# Some modules survive better if they're left loaded
for x in $MODULES_WHITELIST; do
        MODULES=`echo $MODULES | sed s/$x//g`;
done

# Shut down services known to misbehave
for x in $STOP_SERVICES; do
        invoke-rc.d --quiet $x stop
done

# Now remove various modules that might misbehave while suspending
for x in $MODULES; do
    rmmod $x 2>/dev/null;
done

# And remember which console we're on
CONSOLE=`fgconsole`

# Change away from X, otherwise it'll blow up when we POST the video interface
chvt 12

# And then try to save some video state
#if [ x$SAVE_VBE_STATE = "xtrue" ]; then
#  VBESTATE=`tempfile`
#  vbetool vbestate save >$VBESTATE;
#fi

# Now source everything in /etc/acpi/suspend.d/
for SCRIPT in /etc/acpi/suspend.d/*.sh; do
  . $SCRIPT
done

# Make sure the backlight goes off
if [ x$USE_DPMS = "xtrue" ]; then
  vbetool dpms off
fi

