#!/bin/bash

# Post the video card
if [ x$POST_VIDEO = xtrue ]; then
  vbetool post
fi

# Attempt to restore some video card state
if [ x$SAVE_VBE_STATE = xtrue ]; then
  vbetool vbestate restore <$VBESTATE
fi

# Now source everything in /etc/acpi/resume.d/
for SCRIPT in /etc/acpi/resume.d/*.sh; do
  . $SCRIPT
done

# Increase the firmware loading timeout while we're doing this
# Otherwise, swap thrash tends to lead to failure to start
if [ -f /sys/class/firmware/timeout ]; then
    timeout=`cat /sys/class/firmware/timeout`
    echo 100 >/sys/class/firmware/timeout
fi

# Load any drivers that we removed
for x in $MODULES; do
    modprobe $x;
#run ifrename so that the interfaces are the same as previously
    ifrename
done

# And reset the firmware timeout
if [ -f /sys/class/firmware/timeout ]; then
    echo $timeout >/sys/class/firmware/timeout
fi

# Get PCMCIA cards back
cardctl insert

# Restart IR if necessary
if [ -f /var/run/irdadev ] && [ x$RESTART_IRDA = xtrue ]; then
    rm /var/run/irdadev;
    /etc/init.d/irda-setup start;
    /etc/init.d/irda-utils start;
fi;

# Bring up the interfaces (this should probably be left up to some policy
# manager, but at the moment we just bring back whatever we ifdowned)
#for x in $INTERFACES; do
#    ifup $x;
#done

# Actually, we don't for the moment - we end up waiting for things to time out
# because multiple ifups want to write to the state file and it's locked. We
# need a better way of doing this - for now just bring back up whatever is
# flagged as auto

ifup -a &

# Reset the time
hwclock --hctosys

# And make sure that the screen is on
if [ x$USE_DPMS = xtrue ]; then
  vbetool dpms on
fi

# Make sure that the drive power state is set correctly again
rmmod ac
modprobe ac
rmmod battery
modprobe battery
/etc/acpi/power.sh

# Some hardware needs another X/console switch in order to bring stuff back
chvt $CONSOLE;
if [ x$DOUBLE_CONSOLE_SWITCH = xtrue ]; then
  chvt 12;
  chvt $CONSOLE;
fi

# now, we should poke xscreensaver so you get a dialog
for x in /tmp/.X11-unix/*; do
    displaynum=`echo $x | sed s#/tmp/.X11-unix/X##`
    getXuser;
    if [ x"$XAUTHORITY" != x"" ]; then
        export DISPLAY=":$displaynum"
	su $user -c "(xscreensaver-command -deactivate)"
    fi
done

# we need to restart our services after the network is back
for x in $STOP_SERVICES; do
        invoke-rc.d --quiet $x start
done

# Some hardware gets unhappy about button events unless we do this
rmmod button
modprobe button

# Kick the fans
rmmod fan
rmmod thermal
modprobe fan
modprobe thermal

if [ "`grep ibm_acpi /proc/modules`" ]; then
    # No, I don't know why
    rmmod ibm-acpi
    modprobe ibm-acpi
fi

# NNGH FAN HATE
for x in /proc/acpi/fan/*; do
    if [ "`grep on $x/state`" ]; then
	echo -n 3 > $x/state;
	echo -n 0 > $x/state;
    fi
done

#Let acpid process events again
(sleep 5 && rm /var/lock/acpisleep)&
