#!/bin/sh
# INIT script to check whether we're on batteries, and so start with laptop 
# mode etc enabled.

# BUGS: unless we start *really* late, we have no way of throttling 
# xscreensaver, since it won't be there to command.
. /usr/share/acpi-support/power-funcs

test -f /lib/lsb/init-functions || exit 1
. /lib/lsb/init-functions

case "$1" in
  start)
    log_begin_msg "Checking battery state..."
    if [ -d /proc/acpi/ac_adapter ]; then 
        grep -q off-line /proc/acpi/ac_adapter/*/state >/dev/null 2>&1
        if [ $? = 0 ]
        then
                $LAPTOP_MODE start
                $HDPARM -S 12 /dev/hda
                $HDPARM -B 1 /dev/hda
        fi
    fi
    log_end_msg 0
    ;;
  stop)
    log_begin_msg "Disabling power management..."
    if [ -d /proc/acpi/ac_adapter ]; then
        grep -q off-line /proc/acpi/ac_adapter/*/state >/dev/null 2>&1
        if [ $? = 0 ]
        then
                $HDPARM -B 255 /dev/hda
                $LAPTOP_MODE stop
        fi
    fi
    log_end_msg 0
    ;;
  *)
  ;;
esac
        

