#include <test-util.h>

#include <libcapture/pkgcache.h>
#include <libcapture/pkgmanager.h>
#include <apt-pkg/configuration.h>
#include <iostream>

namespace tut {

    using namespace std;
    using namespace capture;

    struct pkgcache_shar {
    };
    
    typedef test_group<pkgcache_shar> tg;
    typedef tg::object to;
    tg pkgcache_tg ("pkgcache");
    template<> template<>
    void to::test<1> ()
    {
        cacheInit (true);
        pkgCache::PkgIterator P;
        // P = (PkgManager::cache ()) -> FindPkg ("amavis-ng");
        // PkgManager::cache () -> setExtState (P, true, 500);
        // PkgManager::cache () -> updateAWanted (true);
        P = (PkgManager::cache ()) -> FindPkg ("k3b");
        PkgManager::cache () -> setExtState (P, true, 500);
        PkgManager::cache () -> updateAWanted ();
        P = (PkgManager::cache ()) -> FindPkg ("kapture");
        PkgManager::cache () -> setExtState (P, true, 500);
        PkgManager::cache () -> updateAWanted ();
        /* P = (PkgManager::cache ()) -> FindPkg ("apt-listchanges");
           PkgManager::cache () -> setExtState (P, true, 900);
           PkgManager::cache () -> updateAWanted (true);
           P = (PkgManager::cache ()) -> FindPkg ("exim");
           PkgManager::cache () -> setExtState (P, true, 600);
           PkgManager::cache () -> updateAWanted (true);
           P = (PkgManager::cache ()) -> FindPkg ("harden");
           PkgManager::cache () -> setExtState (P, true, 700);
           PkgManager::cache () -> updateAWanted (true); */
        /* P = (PkgManager::cache ()) -> FindPkg ("rmail");
           PkgManager::cache () -> setExtState (P, true, 200); */
        
        // PkgManager::cache () -> updateAWanted (0);
        // PkgManager::cache () -> saveExtState ("pkgcache-test.out");
        /* PkgManager::cache () -> updateAWanted (1);
           PkgManager::cache () -> saveExtState ("pkgcache-test-1.out");
           PkgManager::cache () -> updateAWanted (2);
           PkgManager::cache () -> saveExtState ("pkgcache-test-2.out"); */
        cout << "WANTED PACKAGES:" << endl;
        PkgCache::ExtState *s;
        for (pkgCache::PkgIterator mP = PkgManager::cache() -> PkgBegin (); ! mP . end (); mP ++) {
            s = PkgManager::cache() -> extState (mP);
            if (s -> a_wanted_pri > s -> a_unwanted_pri) {
                cout << mP . Name ()
                    << ": a_wanted_pri = " << s -> a_wanted_pri
                    << ", a_unwanted_pri = " << s -> a_unwanted_pri << endl;
            }
        }
        cout << "UNWANTED PACKAGES:" << endl;
        for (pkgCache::PkgIterator mP = PkgManager::cache() -> PkgBegin (); ! mP . end (); mP ++) {
            s = PkgManager::cache() -> extState (mP);
            if (s -> a_unwanted_pri > s -> a_wanted_pri) {
                cout << mP . Name ()
                    << ": a_wanted_pri = " << s -> a_wanted_pri
                    << ", a_unwanted_pri = " << s -> a_unwanted_pri << endl;
            }
        }
    }
}
