#include <functional>
#include <ext/functional>
#include <algorithm>
#include <cmath>
#include <apt-front/cache/entity/tag.h>
#include <apt-front/cache/component/tags.h>
#include <adept/filtersidebar.h>
#include <adept/tagchooser.h>

using namespace adept;
using namespace aptFront;
using namespace std;
using namespace __gnu_cxx;

template< typename H, typename G1, typename G2 >
struct _compose2_binary {
    _compose2_binary( H _h, G1 _g1, G2 _g2 )
        : h( _h ), g1( _g1 ), g2( _g2 )
    {}

    typename H::result_type operator()(
        typename G1::argument_type a,
        typename G2::argument_type b )
    {
        return h( g1( a ), g2( b ) );
    }

    H h;
    G1 g1;
    G2 g2;
};

template< typename H, typename G1, typename G2 >
_compose2_binary< H, G1, G2 > compose2_binary( H h, G1 g1, G2 g2 ) {
    return _compose2_binary< H, G1, G2 >( h, g1, g2 );
}

void FilterSidebar::setCardinality( const Lister::Cardinality &c )
{
    cache::entity::Tag::Set all, smart;

    kdDebug() << "FilterSidebar::setCardinality" << endl;
    Lister::Cardinality cprime;
    remove_copy_if( c.begin(), c.end(), inserter( cprime, cprime.begin() ),
                    compose1( bind1st( equal_to< int >(), 0 ),
                              select2nd<
                              Lister::Cardinality::value_type >() ) );
    transform( cprime.begin(), cprime.end(), inserter( all, all.begin() ),
               select1st< Lister::Cardinality::value_type >() );
    m_all->setTags( all );
    cache::component::Tags &t = cache::Global().get().tags();
    m_easy->setTags( all ^ ( t.facetByName( "interface" ).tags()
                             + t.facetByName( "works-with" ).tags()
                             + t.facetByName( "use" ).tags()
                             + t.facetByName( "role" ).tags() ) );

    typedef vector< pair< cache::entity::Tag, int > > Vec;
    Vec vec;
    copy( cprime.begin(), cprime.end(), back_inserter( vec ) );
    sort( vec.begin(), vec.end(),
          compose2_binary( less< int >(),
                           select2nd< Vec::value_type >(),
                           select2nd< Vec::value_type >() ) );
    Vec::reverse_iterator end = vec.rbegin();
    advance( end, vec.size() < 10 ? vec.size() : 10 );
    transform( vec.rbegin(), end, inserter( smart, smart.begin() ),
               select1st< Vec::value_type >() );
    
    m_smart->setTags( smart );
    m_smart->openToplevel();
}
