#include <klocale.h>
#include <qdragobject.h>

#include <ept/debtags/vocabulary.h>
#include <apt-front/cache/component/packagetags.h>
#include <adept/tagchooser.h>
#include <adept/taglist.h>
#include <adept/utils.h>
#include <wibble/operators.h>

using namespace adept;

FacetItem::FacetItem( TagChooser *t )
    : KListViewItem( t )
{
}

void FacetItem::removeTag( TagItem::Tag t ) {
    // kdDebug() << "removing tag " << t.fullname() << endl;
    for ( QListViewItem *n, *i = firstChild(); i != 0; i = n ) {
        n = i->nextSibling();
        if ( dynamic_cast< TagItem * >( i )->tag() == t )
            delete i;
    }
}

TagItem::TagItem( FacetItem *p )
    : KListViewItem( p ), m_toplevel( false )
{
}

TagItem::TagItem( TagChooser *l )
    : KListViewItem( l ), m_toplevel( true )
{
}

QString TagItem::text( int c ) const
{
    if (c != 0) return u8( "" );
    return QString( "[" ) + m_tag.name() + "] " + m_tag.shortDescription("");
}

TagChooser::TagChooser( QWidget *p, const char *n )
    : KListView( p, n )
{
    observeComponent< cache::component::PackageTags >();
    // addColumn( " ", 20 );
    setRootIsDecorated( true );
    addColumn( i18n( "Available Tags" ) );
    setResizeMode( LastColumn );
    setDragEnabled( true );
    setAcceptDrops( true );
    viewport()->setAcceptDrops( false );
    // kdDebug() << "TagChooser: tags set" << endl;
}

void TagChooser::openToplevel() {
    QListViewItem *i;
    for ( i = firstChild(); i != 0; i = i->nextSibling() ) {
        i->setOpen( true );
    }
}

QDragObject *TagChooser::dragObject()
{
    TagItem *sel = dynamic_cast< TagItem * >( selectedItem() );
    if (sel)
        return new QTextDrag( sel->tag().fullname(), this );
    return 0;
}

void TagChooser::dragEnterEvent( QDragEnterEvent *e )
{
    // hmmmmm :-)
    kdDebug() << "TagChooser::dragEnterEvent" << endl;
    e->accept( dynamic_cast< TagList * >( e->source() )
               && QTextDrag::canDecode( e ) );
    kdDebug() << dynamic_cast< TagList * >( e->source() )
              << "; can decode " << QTextDrag::canDecode( e ) << endl;
}

void TagChooser::dropEvent( QDropEvent* e )
{
    using namespace wibble::operators;
    TagList *tl = dynamic_cast< TagList * >( e->source() );
    QString tag;
    QTextDrag::decode( e, tag );
    tl->setTags( tl->tags() - cache::Global::get().tags().tagByName(
                     static_cast< const char * >( tag.local8Bit() ) ) );
}

QString FacetItem::text( int column ) const
{
    if ( column == 0 )
        return QString( "[" ) + m_facet.name() + "] " + m_facet.shortDescription( "" );
    return u8( "" );
}

static bool drop( TagChooser::Tag t ) {
    if ( t.facet().name() == "special" )
        return true;
    if ( t.name() == "TODO" )
        return true;
    return false;
}

void TagChooser::setTags( Tag::Set s )
{
    using namespace wibble::operators;
    std::set<Tag> remove = m_tags - s;
    std::set<Tag> add = s - m_tags;
    m_tags = s;
    Tag::Set::iterator i;

    for ( i = add.begin(); i != add.end(); ++i ) {

        if ( drop( *i ) )
            continue;

        FacetItem *fi = m_facets[ i->facet() ];
        if ( fi == 0 ) {
            fi = m_facets[ i->facet() ] = new FacetItem( this );
            fi->setFacet( i->facet() );
        }

        TagItem *ti = new TagItem( fi );
        ti->setTag( *i );
    }

    for ( i = remove.begin(); i != remove.end(); ++i ) {

        if ( drop( *i ) )
            continue;

        FacetItem *fi = m_facets[ i->facet() ];
        fi->removeTag( *i );
        if ( fi->childCount() == 0 ) {
            m_facets[ i->facet() ] = 0;
            delete fi;
        }
    }

}

void TagChooser::notifyPreRebuild( cache::component::Base *b ) {
    setTags( Tag::Set() );
}
