/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  int opcode;   /* Either TK_GLOB or TK_LIKE */
  int not;      /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 243
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct LikeOp yy30;
  Select* yy91;
  struct AttachKey yy92;
  IdList* yy232;
  struct {int value; int mask;} yy319;
  ExprList* yy322;
  int yy328;
  struct TrigEvent yy378;
  struct LimitVal yy388;
  Expr* yy418;
  Token yy430;
  SrcList* yy439;
  TriggerStep* yy451;
  int yy485;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 569
#define YYNRULE 309
#define YYERRORSYMBOL 143
#define YYERRSYMDT yy485
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   263,    9,  261,  154,  124,  126,  128,  130,  132,  134,
 /*    10 */   136,  138,  140,  142,  406,    2,  145,  646,    4,  369,
 /*    20 */   144,  114,  116,  112,  118,  849,  124,  126,  128,  130,
 /*    30 */   132,  134,  136,  138,  140,  142,  136,  138,  140,  142,
 /*    40 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*    50 */   114,  116,  112,  118,  572,  124,  126,  128,  130,  132,
 /*    60 */   134,  136,  138,  140,  142,  579,  223,  533,  262,  124,
 /*    70 */   126,  128,  130,  132,  134,  136,  138,  140,  142,    7,
 /*    80 */    96,  145,   13,  535,  536,  144,  442,   78,  371,   92,
 /*    90 */   453,  373,  380,  385,  132,  134,  136,  138,  140,  142,
 /*   100 */    75,    3,  567,  388,  296,  110,   94,  146,  157,  162,
 /*   110 */   167,  156,  161,  120,  122,  114,  116,  112,  118,   77,
 /*   120 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   130 */   145,   10,  578,   13,  144,   11,  279,  569,  371,    6,
 /*   140 */     5,  373,  380,  385,  358,   25,    3,  567,   14,   15,
 /*   150 */   426,  507,  233,  388,  110,   94,  146,  157,  162,  167,
 /*   160 */   156,  161,  120,  122,  114,  116,  112,  118,   77,  124,
 /*   170 */   126,  128,  130,  132,  134,  136,  138,  140,  142,  577,
 /*   180 */   280,  258,  407,   77,  159,  281,  107,  106,  108,  107,
 /*   190 */   106,  108,  879,    1,  568,  172,  295,    4,  670,   14,
 /*   200 */    15,  371,  175,  145,  373,  380,  385,  144,  518,  343,
 /*   210 */   346,   16,   17,   18,  158,  367,  388,  415,  345,  410,
 /*   220 */    28,  345,   95,  402,   33,   95,  807,  110,   94,  146,
 /*   230 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   240 */   118,   51,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   250 */   140,  142,   44,   45,  805,  101,  102,  103,  101,  102,
 /*   260 */   103,  852,  152,  222,  163,  168,  188,  261,   72,   37,
 /*   270 */   341,   40,   59,   67,   69,  305,  336,  145,  265,   36,
 /*   280 */   340,  144,  806,  338,  171,   13,  173,  174,  335,   27,
 /*   290 */   171,  403,  173,  174,   12,  460,   51,  313,  320,  322,
 /*   300 */   197,  110,   94,  146,  157,  162,  167,  156,  161,  120,
 /*   310 */   122,  114,  116,  112,  118,  288,  124,  126,  128,  130,
 /*   320 */   132,  134,  136,  138,  140,  142,   40,   59,   67,   69,
 /*   330 */   305,  336,  152,  262,  163,  168,  580,  263,  338,  261,
 /*   340 */    96,  145,  364,  362,  387,  144,   52,  170,  494,  466,
 /*   350 */   456,   14,   15,  645,  171,   31,  173,  174,   54,   81,
 /*   360 */    75,  331,  534,  601,  176,  110,   94,  146,  157,  162,
 /*   370 */   167,  156,  161,  120,  122,  114,  116,  112,  118,   77,
 /*   380 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   390 */   152,  367,  163,  168,  325,   57,   58,   48,  297,   32,
 /*   400 */    33,  195,  213,  207,   96,  262,   49,   96,   26,   96,
 /*   410 */    13,   83,   96,   13,  217,  145,  265,   50,  286,  144,
 /*   420 */    46,  169,  368,  401,   75,   13,  367,   75,  176,   75,
 /*   430 */    47,  235,   75,  235,  565,   33,  176,  332,  211,  110,
 /*   440 */    94,  146,  157,  162,  167,  156,  161,  120,  122,  114,
 /*   450 */   116,  112,  118,  266,  124,  126,  128,  130,  132,  134,
 /*   460 */   136,  138,  140,  142,  303,   13,  298,  229,  227,  236,
 /*   470 */    96,  692,  292,   48,  243,   96,   14,   15,  217,   14,
 /*   480 */    15,  145,   49,  822,  278,  144,  217,  455,   13,   20,
 /*   490 */    75,   14,   15,   50,  190,   75,  201,   13,   65,  176,
 /*   500 */    13,  250,  593,  253,   66,  110,   94,  146,  157,  162,
 /*   510 */   167,  156,  161,  120,  122,  114,  116,  112,  118,   77,
 /*   520 */   124,  126,  128,  130,  132,  134,  136,  138,  140,  142,
 /*   530 */   665,   14,   15,  693,  585,  250,  351,  356,  357,  871,
 /*   540 */   152,  191,  163,  168,  479,  628,  145,  327,   34,  216,
 /*   550 */   144,  366,  349,   22,   14,   15,   13,  331,  255,  171,
 /*   560 */   461,  173,  174,   14,   15,  463,   14,   15,  857,  252,
 /*   570 */   110,   94,  146,  157,  162,  167,  156,  161,  120,  122,
 /*   580 */   114,  116,  112,  118,  850,  124,  126,  128,  130,  132,
 /*   590 */   134,  136,  138,  140,  142,  251,  855,  273,  358,  187,
 /*   600 */   354,  356,  357,  252,  171,  310,  173,  174,   39,   42,
 /*   610 */   350,  399,  309,  145,  261,  829,  335,  144,  398,  455,
 /*   620 */   586,  294,   14,   15,   64,  293,  397,  667,  537,  251,
 /*   630 */   499,   77,  171,  328,  173,  174,  731,  110,   94,  146,
 /*   640 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   650 */   118,   77,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   660 */   140,  142,  358,  312,   96,  505,   96,  501,  338,   96,
 /*   670 */   171,   96,  173,  174,  441,  845,  479,   24,  145,  532,
 /*   680 */   262,  275,  144,  331,   75,  214,   75,  215,  493,   75,
 /*   690 */   302,   75,  465,  493,  272,   91,  273,  463,  171,  694,
 /*   700 */   173,  174,  110,   94,  146,  157,  162,  167,  156,  161,
 /*   710 */   120,  122,  114,  116,  112,  118,  376,  124,  126,  128,
 /*   720 */   130,  132,  134,  136,  138,  140,  142,  587,   96,  171,
 /*   730 */   489,  173,  174,   96,   96,  525,   96,  246,  171,  271,
 /*   740 */   173,  174,   96,  145,  432,  434,  433,  144,   75,  503,
 /*   750 */   588,  452,   93,   75,   75,  348,   75,  109,  111,  332,
 /*   760 */   113,  265,   75,  342,  248,  258,  115,  110,  165,  146,
 /*   770 */   157,  162,  167,  156,  161,  120,  122,  114,  116,  112,
 /*   780 */   118,   29,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   790 */   140,  142,  815,   96,   96,   96,   96,  299,  283,  215,
 /*   800 */   310,   96,   96,   96,   96,  364,  362,  219,  145,  317,
 /*   810 */   316,  275,  144,   75,   75,   75,   75,  117,  119,  121,
 /*   820 */   123,   75,   75,   75,   75,  125,  127,  129,  131,  352,
 /*   830 */   247,  353,  404,   94,  146,  157,  162,  167,  156,  161,
 /*   840 */   120,  122,  114,  116,  112,  118,   96,  124,  126,  128,
 /*   850 */   130,  132,  134,  136,  138,  140,  142,   96,  312,   96,
 /*   860 */    96,  331,   96,  331,   77,   96,   75,   96,   96,  436,
 /*   870 */   133,   30,  261,   96,  145,   96,   38,   75,  144,   75,
 /*   880 */    75,  135,   75,  137,  139,   75,  141,   75,   75,  143,
 /*   890 */   592,  153,  155,   75,  382,   75,  391,  164,  331,  166,
 /*   900 */   146,  157,  162,  167,  156,  161,  120,  122,  114,  116,
 /*   910 */   112,  118,  725,  124,  126,  128,  130,  132,  134,  136,
 /*   920 */   138,  140,  142,   76,   96,   96,  438,   71,  471,  437,
 /*   930 */    96,  449,   96,   96,  326,   96,  327,  332,  262,  332,
 /*   940 */    96,  439,  148,   42,   75,   75,  147,   35,  178,  180,
 /*   950 */    75,  199,   75,   75,  182,   75,  184,  196,  694,  198,
 /*   960 */    75,  107,  106,  108,  208,  430,  431,  177,  421,  657,
 /*   970 */   150,  151,  360,  361,  332,   96,   96,  548,  383,  421,
 /*   980 */   327,   96,  725,  318,  183,  181,  300,   96,   96,  450,
 /*   990 */    96,  327,  179,   73,   74,   75,   75,   95,  149,  210,
 /*  1000 */   212,   75,  290,  319,   96,  224,  558,   75,   75,   76,
 /*  1010 */    75,  240,  245,   71,  277,  275,  435,  423,   96,   96,
 /*  1020 */    96,   96,   75,  392,   75,  327,  287,  457,  386,  244,
 /*  1030 */   101,  102,  103,  104,  105,  185,  189,  199,   75,   75,
 /*  1040 */    75,   75,  427,  474,  478,  491,  694,  107,  106,  108,
 /*  1050 */   559,  219,  414,  177,   81,  484,  562,  273,  315,  486,
 /*  1060 */   219,  458,   45,   42,  492,  476,  490,  487,  421,  421,
 /*  1070 */   183,  181,  844,  483,  421,  421,  421,  421,  179,   73,
 /*  1080 */    74,  476,   81,   95,   77,  421,  526,  865,  490,   43,
 /*  1090 */   659,   77,   41,   53,  522,  523,   56,   55,   60,  244,
 /*  1100 */    61,   76,   81,   62,   64,   71,  500,  502,   70,  602,
 /*  1110 */    68,   63,  504,  506,  510,  514,  101,  102,  103,  104,
 /*  1120 */   105,  185,  189,  520,  546,  603,   77,   81,  470,  199,
 /*  1130 */    79,   80,  875,  244,   82,  239,  241,   84,  225,  107,
 /*  1140 */   106,  108,   85,   87,  516,  177,   86,   88,   90,   98,
 /*  1150 */    89,   97,   99,  100,  142,  160,  218,  671,  672,  673,
 /*  1160 */   186,  209,  183,  181,  194,  200,  203,  202,  192,  206,
 /*  1170 */   179,   73,   74,  204,  205,   95,  221,  193,  219,  220,
 /*  1180 */   226,  228,  232,  230,  231,  233,  242,  237,  234,  238,
 /*  1190 */   215,  249,  254,   76,  257,  260,  276,   71,  256,  259,
 /*  1200 */   264,  267,  269,  268,  270,  274,  282,  291,  101,  102,
 /*  1210 */   103,  104,  105,  185,  189,  808,  285,  301,  304,  306,
 /*  1220 */   284,  199,  324,  311,  355,  330,  307,  374,  308,  329,
 /*  1230 */   375,  107,  106,  108,  333,  309,  337,  177,  314,  334,
 /*  1240 */   372,  321,  344,  323,  378,  347,  381,  379,  365,  359,
 /*  1250 */   339,  389,  377,  400,  183,  181,  289,  384,  363,  390,
 /*  1260 */   370,  393,  179,   73,   74,  394,  395,   95,   54,  396,
 /*  1270 */   408,  409,  411,  412,  413,  416,  420,  417,  422,   76,
 /*  1280 */   428,  837,  429,   71,  443,  440,  444,  842,  843,  445,
 /*  1290 */   446,  447,  451,  448,  813,  454,  814,  459,  462,  732,
 /*  1300 */   101,  102,  103,  104,  105,  185,  189,  199,  836,  464,
 /*  1310 */   851,  457,  467,  418,  468,  733,  469,  107,  106,  108,
 /*  1320 */   424,  419,  475,  177,  473,  853,  472,  477,  425,  480,
 /*  1330 */   481,  482,  488,  485,  854,  495,  497,  856,  496,  664,
 /*  1340 */   183,  181,  666,  821,  863,  509,  511,  724,  179,   73,
 /*  1350 */    74,  513,  727,   95,  517,  515,  519,  730,  521,  524,
 /*  1360 */     8,  823,  528,  530,  824,   19,   21,   23,  405,  531,
 /*  1370 */   825,  826,  827,  539,  538,  828,  549,  542,  543,  540,
 /*  1380 */   541,  864,  544,  547,  866,  550,  101,  102,  103,  104,
 /*  1390 */   105,  185,  189,  545,  867,  552,  870,  872,  529,  557,
 /*  1400 */   460,  551,  555,  560,  554,  527,  873,  553,  561,  563,
 /*  1410 */   564,  566,  556,  874,  553,  553,  553,  553,  553,  553,
 /*  1420 */   553,  553,  553,  553,  553,  553,  553,  553,  553,  553,
 /*  1430 */   553,  553,  553,  553,  553,  553,  553,  553,  553,  553,
 /*  1440 */   553,  553,  553,  553,  553,  553,  553,  553,  553,  553,
 /*  1450 */   553,  553,  553,  508,  512,  456,  553,  553,  553,  498,
 /*  1460 */   553,  553,  553,  553,   81,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    24,  150,   26,   78,   79,   80,   81,   82,   83,   84,
 /*    10 */    85,   86,   87,   88,  155,  146,   40,   23,  149,   25,
 /*    20 */    44,   74,   75,   76,   77,   11,   79,   80,   81,   82,
 /*    30 */    83,   84,   85,   86,   87,   88,   85,   86,   87,   88,
 /*    40 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    50 */    74,   75,   76,   77,    9,   79,   80,   81,   82,   83,
 /*    60 */    84,   85,   86,   87,   88,    9,   25,  152,   92,   79,
 /*    70 */    80,   81,   82,   83,   84,   85,   86,   87,   88,    9,
 /*    80 */   152,   40,   26,  168,  169,   44,  227,  159,   94,   48,
 /*    90 */   231,   97,   98,   99,   83,   84,   85,   86,   87,   88,
 /*   100 */   172,    9,   10,  109,  176,   64,   65,   66,   67,   68,
 /*   110 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  191,
 /*   120 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   130 */    40,  151,    9,   26,   44,   12,  159,    0,   94,  147,
 /*   140 */   148,   97,   98,   99,  229,  153,    9,   10,   92,   93,
 /*   150 */   136,  159,   26,  109,   64,   65,   66,   67,   68,   69,
 /*   160 */    70,   71,   72,   73,   74,   75,   76,   77,  191,   79,
 /*   170 */    80,   81,   82,   83,   84,   85,   86,   87,   88,    9,
 /*   180 */   203,  204,   20,  191,   66,  208,   60,   61,   62,   60,
 /*   190 */    61,   62,  144,  145,  146,  112,   23,  149,  115,   92,
 /*   200 */    93,   94,   23,   40,   97,   98,   99,   44,  216,   83,
 /*   210 */    84,   13,   14,   15,   96,  152,  109,   55,   92,   57,
 /*   220 */   157,   92,   96,  160,  161,   96,  136,   64,   65,   66,
 /*   230 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   240 */    77,   66,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   250 */    87,   88,  188,  189,   17,  129,  130,  131,  129,  130,
 /*   260 */   131,   17,  219,  220,  221,  222,   23,   26,   22,   94,
 /*   270 */    95,   96,   97,   98,   99,  100,  101,   40,  165,  170,
 /*   280 */   171,   44,   17,  108,  111,   26,  113,  114,  179,   22,
 /*   290 */   111,   24,  113,  114,  152,   51,   66,  104,  105,  106,
 /*   300 */   137,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   310 */    73,   74,   75,   76,   77,  202,   79,   80,   81,   82,
 /*   320 */    83,   84,   85,   86,   87,   88,   96,   97,   98,   99,
 /*   330 */   100,  101,  219,   92,  221,  222,    9,   24,  108,   26,
 /*   340 */   152,   40,   83,   84,  173,   44,   96,  159,  104,  105,
 /*   350 */   106,   92,   93,   23,  111,   25,  113,  114,  108,  115,
 /*   360 */   172,  152,  103,  117,  176,   64,   65,   66,   67,   68,
 /*   370 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  191,
 /*   380 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   390 */   219,  152,  221,  222,  185,   13,   14,   18,   23,  160,
 /*   400 */   161,  136,  214,  138,  152,   92,   27,  152,  154,  152,
 /*   410 */    26,  194,  152,   26,  226,   40,  165,   38,  201,   44,
 /*   420 */    41,   22,  183,  184,  172,   26,  152,  172,  176,  172,
 /*   430 */    51,  176,  172,  176,  160,  161,  176,  228,  137,   64,
 /*   440 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   450 */    75,   76,   77,  202,   79,   80,   81,   82,   83,   84,
 /*   460 */    85,   86,   87,   88,   23,   26,  214,  212,  211,  212,
 /*   470 */   152,   23,   85,   18,  214,  152,   92,   93,  226,   92,
 /*   480 */    93,   40,   27,    9,   22,   44,  226,  159,   26,  151,
 /*   490 */   172,   92,   93,   38,  176,  172,   41,   26,   29,  176,
 /*   500 */    26,   25,    9,  119,   35,   64,   65,   66,   67,   68,
 /*   510 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  191,
 /*   520 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   530 */     9,   92,   93,   23,    9,   25,  167,  168,  169,    9,
 /*   540 */   219,  223,  221,  222,  216,   23,   40,   25,  162,  226,
 /*   550 */    44,  165,  166,  151,   92,   93,   26,  152,  119,  111,
 /*   560 */   232,  113,  114,   92,   93,  237,   92,   93,    9,   93,
 /*   570 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   580 */    74,   75,   76,   77,   11,   79,   80,   81,   82,   83,
 /*   590 */    84,   85,   86,   87,   88,  119,    9,   25,  229,  159,
 /*   600 */   167,  168,  169,   93,  111,   45,  113,  114,  171,  103,
 /*   610 */    22,  179,  180,   40,   26,    9,  179,   44,  186,  159,
 /*   620 */     9,  112,   92,   93,  102,  116,   66,    9,   22,  119,
 /*   630 */    20,  191,  111,  228,  113,  114,    9,   64,   65,   66,
 /*   640 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   650 */    77,  191,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   660 */    87,   88,  229,  103,  152,   55,  152,   57,  108,  152,
 /*   670 */   111,  152,  113,  114,   21,  103,  216,  151,   40,   73,
 /*   680 */    92,  152,   44,  152,  172,   23,  172,   25,  176,  172,
 /*   690 */   176,  172,  232,  176,   23,  176,   25,  237,  111,    9,
 /*   700 */   113,  114,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   710 */    72,   73,   74,   75,   76,   77,  185,   79,   80,   81,
 /*   720 */    82,   83,   84,   85,   86,   87,   88,    9,  152,  111,
 /*   730 */   218,  113,  114,  152,  152,  218,  152,   25,  111,  210,
 /*   740 */   113,  114,  152,   40,  104,  105,  106,   44,  172,  139,
 /*   750 */     9,   98,  176,  172,  172,  164,  172,  176,  176,  228,
 /*   760 */   176,  165,  172,  172,  203,  204,  176,   64,   65,   66,
 /*   770 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   780 */    77,  158,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   790 */    87,   88,  139,  152,  152,  152,  152,   23,  202,   25,
 /*   800 */    45,  152,  152,  152,  152,   83,   84,  117,   40,   95,
 /*   810 */    96,  152,   44,  172,  172,  172,  172,  176,  176,  176,
 /*   820 */   176,  172,  172,  172,  172,  176,  176,  176,  176,   23,
 /*   830 */   118,   25,  159,   65,   66,   67,   68,   69,   70,   71,
 /*   840 */    72,   73,   74,   75,   76,   77,  152,   79,   80,   81,
 /*   850 */    82,   83,   84,   85,   86,   87,   88,  152,  103,  152,
 /*   860 */   152,  152,  152,  152,  191,  152,  172,  152,  152,  210,
 /*   870 */   176,   23,   26,  152,   40,  152,  152,  172,   44,  172,
 /*   880 */   172,  176,  172,  176,  176,  172,  176,  172,  172,  176,
 /*   890 */     9,  176,  176,  172,  185,  172,  185,  176,  152,  176,
 /*   900 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   910 */    76,   77,    9,   79,   80,   81,   82,   83,   84,   85,
 /*   920 */    86,   87,   88,   22,  152,  152,   28,   26,   25,   31,
 /*   930 */   152,  185,  152,  152,   23,  152,   25,  228,   92,  228,
 /*   940 */   152,   43,   40,  103,  172,  172,   44,  163,  176,  176,
 /*   950 */   172,   50,  172,  172,  176,  172,  176,  176,   24,  176,
 /*   960 */   172,   60,   61,   62,  176,   53,   54,   66,  152,    9,
 /*   970 */    68,   69,  129,  130,  228,  152,  152,  131,   23,  152,
 /*   980 */    25,  152,    9,   32,   83,   84,   85,  152,  152,   23,
 /*   990 */   152,   25,   91,   92,   93,  172,  172,   96,   96,  176,
 /*  1000 */   176,  172,  152,   52,  152,  176,  190,  172,  172,   22,
 /*  1010 */   172,  176,  176,   26,  176,  152,   47,  190,  152,  152,
 /*  1020 */   152,  152,  172,   23,  172,   25,  176,   64,  176,  126,
 /*  1030 */   129,  130,  131,  132,  133,  134,  135,   50,  172,  172,
 /*  1040 */   172,  172,  176,  176,  176,  176,  103,   60,   61,   62,
 /*  1050 */    59,  117,  159,   66,  115,   23,  240,   25,  107,  159,
 /*  1060 */   117,  188,  189,  103,   23,  152,   25,  128,  152,  152,
 /*  1070 */    83,   84,  103,  210,  152,  152,  152,  152,   91,   92,
 /*  1080 */    93,  152,  115,   96,  191,  152,   23,    9,   25,   33,
 /*  1090 */   127,  191,  173,  173,  159,  128,   42,  182,   46,  126,
 /*  1100 */   174,   22,  115,  173,  102,   26,  190,  190,   22,  117,
 /*  1110 */   173,  175,  190,  190,  190,  190,  129,  130,  131,  132,
 /*  1120 */   133,  134,  135,  190,   46,  117,  191,  115,  215,   50,
 /*  1130 */   192,  191,  141,  126,  193,  124,  123,  195,  121,   60,
 /*  1140 */    61,   62,  196,  198,  215,   66,  197,  199,  125,  152,
 /*  1150 */   200,  117,  117,  152,   88,   96,  152,  115,  115,  115,
 /*  1160 */    22,  136,   83,   84,   17,   22,  189,   23,  224,   23,
 /*  1170 */    91,   92,   93,   25,  152,   96,  156,  225,  117,  152,
 /*  1180 */   122,   25,  101,  213,  174,   26,  122,  213,  164,  174,
 /*  1190 */    25,  205,  152,   22,  119,  156,  103,   26,  152,  152,
 /*  1200 */   152,  206,  120,  207,   22,  152,   23,  117,  129,  130,
 /*  1210 */   131,  132,  133,  134,  135,  136,  207,   23,  173,  152,
 /*  1220 */   206,   50,   22,  152,   23,  174,  177,   46,  178,  213,
 /*  1230 */    22,   60,   61,   62,  213,  180,  164,   66,  181,  174,
 /*  1240 */   152,  181,  172,  181,   23,  172,   22,  173,  165,  230,
 /*  1250 */   182,   46,  175,  184,   83,   84,   85,  173,  230,   22,
 /*  1260 */   184,  100,   91,   92,   93,  152,  177,   96,  108,  178,
 /*  1270 */   152,  156,  152,  156,   24,  152,  103,  156,  156,   22,
 /*  1280 */    39,   11,   37,   26,  139,   47,  152,  103,  103,  156,
 /*  1290 */   103,  152,  173,   22,    9,   11,  139,  187,   17,  127,
 /*  1300 */   129,  130,  131,  132,  133,  134,  135,   50,    9,    9,
 /*  1310 */    17,   64,  187,  233,  152,  127,  107,   60,   61,   62,
 /*  1320 */   235,  234,  196,   66,   73,    9,  152,   73,  236,  127,
 /*  1330 */   152,   22,   22,  217,    9,  118,  196,    9,  152,    9,
 /*  1340 */    83,   84,    9,    9,    9,  118,  196,    9,   91,   92,
 /*  1350 */    93,  187,    9,   96,  196,  107,  127,    9,  217,   22,
 /*  1360 */    11,    9,  152,  152,    9,   16,   17,   18,   19,  156,
 /*  1370 */     9,    9,    9,   23,  152,    9,   34,  165,   24,   30,
 /*  1380 */   238,    9,  152,  165,    9,   36,  129,  130,  131,  132,
 /*  1390 */   133,  134,  135,  239,    9,  152,    9,    9,   49,   20,
 /*  1400 */    51,  238,  156,  140,  152,   56,    9,   58,  152,  141,
 /*  1410 */   241,  142,   63,    9,  242,  242,  242,  242,  242,  242,
 /*  1420 */   242,  242,  242,  242,  242,  242,  242,  242,  242,  242,
 /*  1430 */   242,  242,  242,  242,  242,  242,  242,  242,  242,  242,
 /*  1440 */   242,  242,  242,  242,  242,  242,  242,  242,  242,  242,
 /*  1450 */   242,  242,  242,  104,  105,  106,  242,  242,  242,  110,
 /*  1460 */   242,  242,  242,  242,  115,
};
#define YY_SHIFT_USE_DFLT (-76)
static const short yy_shift_ofst[] = {
 /*     0 */    92,  137,  -76,  -76, 1349,   45,   70,  -76,  198,  123,
 /*    10 */   170,   56,  327,  -76,  -76,  -76,  -76,  -76,  -76,  123,
 /*    20 */   525,  123,  611,  123,  718,  267,  741,  471,  330,  848,
 /*    30 */   881,  107,  -76,  241,  -76,  175,  -76,  471,  230,  -76,
 /*    40 */   840,  -76, 1056,  379,  -76,  -76,  -76,  -76,  -76,  -76,
 /*    50 */   -76,  250,  840,  -76, 1054,  -76,  382,  -76,  -76, 1052,
 /*    60 */   469,  840, 1002,  -76,  -76,  -76,  -76,  840,  -76, 1086,
 /*    70 */  1257,  246,  901,  992, 1008,  -76,  987,  -76,  173, 1012,
 /*    80 */   -76,  509,  -76,  712, 1007, 1013, 1011, 1017, 1023,  -76,
 /*    90 */  1257,   41, 1257,  638, 1257,  -76, 1034,  471, 1035,  471,
 /*   100 */   -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  -76,  834,
 /*   110 */  1257,  768, 1257,  -10, 1257,  -10, 1257,  -10, 1257,  -10,
 /*   120 */  1257,  -53, 1257,  -53, 1257,   11, 1257,   11, 1257,   11,
 /*   130 */  1257,   11, 1257,  -49, 1257,  -49, 1257, 1066, 1257, 1066,
 /*   140 */  1257, 1066, 1257,  -76,  -76,  -76,  902,  -76,  -76,  -76,
 /*   150 */   -76,  -76, 1257,  -75, 1257,  -10,  -76,  118,  -76, 1059,
 /*   160 */   -76,  -76,  -76, 1257,  703, 1257,  -53,  -76,  399,  987,
 /*   170 */   179,   83, 1042, 1043, 1044,  -76,  638, 1257,  834, 1257,
 /*   180 */   -76, 1257,  -76, 1257,  -76, 1138, 1012,  243,  -76, 1079,
 /*   190 */    90, 1025,  265, 1147,  -76, 1257,  163, 1257,  638, 1143,
 /*   200 */   455, 1144,  -76, 1148,  471, 1146,  -76, 1257,  237, 1257,
 /*   210 */   301, 1257,  638,  662,  -76, 1257,  -76,  -76, 1061,  471,
 /*   220 */   -76,  -76,  -76, 1257,  638, 1058, 1257, 1156, 1257, 1081,
 /*   230 */   469,  -76, 1159,  -76,  -76,  638, 1081,  469,  -76, 1257,
 /*   240 */   638, 1064, 1257, 1165, 1257,  638,  -76,  -76,  476,  -76,
 /*   250 */   -76,  -76,  384,  -76,  439,  -76, 1075,  -76,  462, 1061,
 /*   260 */   313,  -76,  -76,  471,  -76,  -76, 1093, 1082,  -76, 1182,
 /*   270 */   471,  671,  -76,  471,  -76,  -76, 1257,  638, 1012,  448,
 /*   280 */   510, 1183,  313, 1093, 1082,  -76, 1171,  -24,  -76,  -76,
 /*   290 */  1090,  387,  -76,  -76,  -76,  -76,  375,  -76,  774,  -76,
 /*   300 */  1194,  -76,  441,  840,  -76,  471, 1200,  -76,  755,  -76,
 /*   310 */   471,  -76,  193,  951,  -76,  714,  -76,  -76,  -76,  -76,
 /*   320 */   951,  -76,  951,  -76,  471,  911,  -76,  471, 1081,  469,
 /*   330 */   -76,  -76, 1081,  469,  -76,  -76, 1159,  -76, 1054,  -76,
 /*   340 */   -76,  126,  -76,  129,  -76,  -76,  129,  -76,  -76,  588,
 /*   350 */   722,  806,  -76,  722, 1201,  -76,  -76,  -76,  843,  -76,
 /*   360 */   -76,  -76,  843,  -76,  -76,  -76,  -76,  -76,   -6,   44,
 /*   370 */   -76,  471,  -76, 1181, 1208,  471,  522, 1221,  840,  -76,
 /*   380 */  1224,  471,  955,  840,  -76, 1257,  506,  -76, 1205, 1237,
 /*   390 */   471, 1000, 1161,  471, 1200,  -76,  560, 1160,  -76,  -76,
 /*   400 */   -76,  -76,  -76, 1012,  493,  653,  162,  471, 1061,  -76,
 /*   410 */   471,  934, 1250, 1012,  521,  471, 1061,  898,  640, 1173,
 /*   420 */   471, 1061,  -76, 1241,   14, 1270, 1257,  573, 1245,  912,
 /*   430 */   -76,  -76, 1184, 1185,  969,  471,  572,  -76,  -76, 1238,
 /*   440 */   -76,  -76, 1145,  471,  943, 1187,  471, 1271,  471,  966,
 /*   450 */   960, 1285, 1157, 1284,  244,  559,  963,  379,  -76, 1172,
 /*   460 */  1188, 1281, 1299, 1300,  244, 1293, 1247,  471, 1209,  471,
 /*   470 */   903,  471, 1251, 1257,  638, 1316, 1254, 1257,  638, 1202,
 /*   480 */   471, 1309,  471, 1032,  -76,  939,  587, 1310, 1257, 1041,
 /*   490 */  1257,  638, 1325,  638, 1217,  471,  973, 1328,  610,  471,
 /*   500 */  1330,  471, 1333,  471, 1334,  471, 1335,  618, 1227,  471,
 /*   510 */   973, 1338, 1247,  471, 1248,  471,  903, 1343, 1229,  471,
 /*   520 */  1309,  967,  627, 1337, 1257, 1063, 1348,  474, 1352,  471,
 /*   530 */  1061,  606,  259, 1355, 1361, 1362, 1363,  471, 1350, 1366,
 /*   540 */  1342,  241, 1354,  471, 1078, 1372,  846, 1375, 1385,  -76,
 /*   550 */  1342,  471, 1387,  530,  690, 1388, 1379,  471,  991, 1263,
 /*   560 */   471, 1397, 1268, 1269,  471, 1404,  -76,  -76,  -76,
};
#define YY_REDUCE_USE_DFLT (-150)
static const short yy_reduce_ofst[] = {
 /*     0 */    48, -131, -150, -150,   -8, -150, -150, -150, -149,  -20,
 /*    10 */  -150,  142, -150, -150, -150, -150, -150, -150, -150,  338,
 /*    20 */  -150,  402, -150,  526, -150,  254, -150,   63,  623, -150,
 /*    30 */  -150,  239, -150,  386,  784,  109, -150,  724,  437, -150,
 /*    40 */   919, -150, -150,   64, -150, -150, -150, -150, -150, -150,
 /*    50 */  -150, -150,  920, -150,  915, -150, -150, -150, -150, -150,
 /*    60 */   926,  930,  936, -150, -150, -150, -150,  937, -150, -150,
 /*    70 */   514, -150,  252, -150, -150, -150,  -72, -150,  938,  940,
 /*    80 */  -150,  941,  217,  942,  946,  949,  945,  948,  950, -150,
 /*    90 */   519,  321,  576,  321,  581, -150, -150,  997, -150, 1001,
 /*   100 */  -150, -150, -150, -150, -150, -150, -150, -150, -150,  321,
 /*   110 */   582,  321,  584,  321,  590,  321,  641,  321,  642,  321,
 /*   120 */   643,  321,  644,  321,  649,  321,  650,  321,  651,  321,
 /*   130 */   652,  321,  694,  321,  705,  321,  707,  321,  708,  321,
 /*   140 */   710,  321,  713,  321, -150, -150, -150, -150, -150, -150,
 /*   150 */  -150, -150,  715,   43,  716,  321, -150, -150, -150, -150,
 /*   160 */  -150, -150, -150,  721,  321,  723,  321, -150, 1004,  188,
 /*   170 */   938, -150, -150, -150, -150, -150,  321,  772,  321,  773,
 /*   180 */   321,  778,  321,  780,  321, -150,  440,  938, -150,  318,
 /*   190 */   321,  944,  952, -150, -150,  781,  321,  783,  321, -150,
 /*   200 */   977, -150, -150, -150, 1022, -150, -150,  788,  321,  823,
 /*   210 */   321,  824,  321, -150, -150,  323, -150, -150, 1020, 1027,
 /*   220 */  -150, -150, -150,  829,  321, -150,  257, -150,  255,  970,
 /*   230 */  1010, -150, 1024, -150, -150,  321,  974, 1015, -150,  835,
 /*   240 */   321, -150,  260, -150,  836,  321, -150,  561,  986, -150,
 /*   250 */  -150, -150, 1040, -150, 1046, -150, -150, -150, 1047, 1039,
 /*   260 */   251, -150, -150, 1048, -150, -150,  995,  996, -150, -150,
 /*   270 */   529, -150, -150, 1053, -150, -150,  838,  321,  -23,  938,
 /*   280 */   986, -150,  596, 1014, 1009, -150,  850,  113, -150, -150,
 /*   290 */  -150,  997, -150, -150, -150, -150,  321, -150, -150, -150,
 /*   300 */  -150, -150,  321, 1045, -150, 1067, 1049, 1050, 1055, -150,
 /*   310 */  1071, -150, -150, 1057, -150, -150, -150, -150, -150, -150,
 /*   320 */  1060, -150, 1062, -150,  209, -150, -150,  405, 1016, 1051,
 /*   330 */  -150, -150, 1021, 1065, -150, -150, 1072, -150, 1068, -150,
 /*   340 */  -150,  591, -150, 1070, -150, -150, 1073, -150, -150, 1083,
 /*   350 */   369, -150, -150,  433, -150, -150, -150, -150, 1019, -150,
 /*   360 */  -150, -150, 1028, -150, -150, -150, -150, -150, 1069, 1076,
 /*   370 */  -150, 1088, -150, -150, -150,  531, 1077, -150, 1074, -150,
 /*   380 */  -150,  709, -150, 1084, -150,  852,  171, -150, -150, -150,
 /*   390 */   711, -150, -150, 1113, 1089, 1091,  432, -150, -150, -150,
 /*   400 */  -150, -150, -150,  673,  938, -141, -150, 1118, 1115, -150,
 /*   410 */  1120, 1117, -150,  893,  938, 1123, 1121, 1080, 1087, -150,
 /*   420 */   827, 1122, -150, 1085, 1092, -150,  866,  321, -150, -150,
 /*   430 */  -150, -150, -150, -150, -150,  659, -150, -150, -150, -150,
 /*   440 */  -150, -150, -150, 1134, 1133, -150, 1139, -150,  746, -150,
 /*   450 */  1119, -150, -150, -150,  328,  938, 1110,  873, -150, -150,
 /*   460 */  -150, -150, -150, -150,  460, -150, 1125, 1162, -150,  913,
 /*   470 */  1126, 1174, -150,  867,  321, -150, -150,  868,  321, -150,
 /*   480 */  1178, 1116,  863, -150, -150,  900,  938, -150,  512, -150,
 /*   490 */   869,  321, -150,  321, -150, 1186, 1140, -150, -150,  916,
 /*   500 */  -150,  917, -150,  922, -150,  923, -150,  938, -150,  924,
 /*   510 */  1150, -150, 1164,  925, -150,  929, 1158, -150, -150,  933,
 /*   520 */  1141,  935,  938, -150,  517, -150, -150, 1210, -150, 1211,
 /*   530 */  1213, -150,  -85, -150, -150, -150, -150, 1222, -150, -150,
 /*   540 */  1142, 1212, -150, 1230, 1154, -150, 1218, -150, -150, -150,
 /*   550 */  1163, 1243, -150, 1252, 1246, -150, -150,  816, -150, -150,
 /*   560 */  1256, -150, -150, 1169,  274, -150, -150, -150, -150,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   575,  575,  570,  573,  878,  878,  878,  574,  581,  878,
 /*    10 */   878,  878,  878,  601,  602,  603,  582,  583,  584,  878,
 /*    20 */   878,  878,  878,  878,  878,  878,  878,  878,  878,  878,
 /*    30 */   878,  878,  594,  604,  613,  596,  612,  878,  878,  614,
 /*    40 */   657,  620,  878,  878,  658,  661,  662,  663,  860,  861,
 /*    50 */   862,  878,  657,  621,  642,  640,  878,  643,  644,  878,
 /*    60 */   713,  657,  628,  622,  629,  711,  712,  657,  623,  878,
 /*    70 */   878,  743,  812,  749,  744,  740,  878,  668,  878,  878,
 /*    80 */   669,  677,  679,  686,  725,  716,  718,  706,  720,  674,
 /*    90 */   878,  721,  878,  722,  878,  742,  878,  878,  745,  878,
 /*   100 */   746,  747,  748,  750,  751,  752,  755,  756,  757,  758,
 /*   110 */   878,  759,  878,  760,  878,  761,  878,  762,  878,  763,
 /*   120 */   878,  764,  878,  765,  878,  766,  878,  767,  878,  768,
 /*   130 */   878,  769,  878,  770,  878,  771,  878,  772,  878,  773,
 /*   140 */   878,  774,  878,  775,  776,  777,  878,  778,  779,  786,
 /*   150 */   793,  796,  878,  781,  878,  780,  783,  878,  784,  878,
 /*   160 */   787,  785,  792,  878,  878,  878,  794,  795,  878,  812,
 /*   170 */   878,  878,  878,  878,  878,  799,  811,  878,  788,  878,
 /*   180 */   789,  878,  790,  878,  791,  878,  878,  878,  801,  878,
 /*   190 */   878,  878,  878,  878,  802,  878,  878,  878,  803,  878,
 /*   200 */   878,  878,  858,  878,  878,  878,  859,  878,  878,  878,
 /*   210 */   878,  878,  804,  878,  797,  812,  809,  810,  694,  878,
 /*   220 */   695,  800,  782,  878,  723,  878,  878,  707,  878,  714,
 /*   230 */   713,  708,  878,  598,  715,  710,  714,  713,  709,  878,
 /*   240 */   719,  878,  812,  717,  878,  726,  678,  689,  687,  688,
 /*   250 */   697,  698,  878,  699,  878,  700,  878,  701,  878,  694,
 /*   260 */   685,  599,  600,  878,  683,  684,  703,  705,  690,  878,
 /*   270 */   878,  878,  704,  878,  738,  739,  878,  702,  689,  878,
 /*   280 */   878,  878,  685,  703,  705,  691,  878,  685,  680,  681,
 /*   290 */   878,  878,  682,  675,  676,  798,  878,  741,  878,  753,
 /*   300 */   878,  754,  878,  657,  624,  878,  816,  630,  625,  631,
 /*   310 */   878,  632,  878,  878,  633,  878,  636,  637,  638,  639,
 /*   320 */   878,  634,  878,  635,  878,  878,  817,  878,  714,  713,
 /*   330 */   818,  820,  714,  713,  819,  626,  878,  627,  642,  641,
 /*   340 */   615,  878,  616,  878,  617,  749,  878,  618,  619,  605,
 /*   350 */   835,  878,  606,  835,  878,  607,  610,  611,  878,  830,
 /*   360 */   832,  833,  878,  831,  834,  609,  608,  597,  878,  878,
 /*   370 */   647,  878,  650,  878,  878,  878,  878,  878,  657,  651,
 /*   380 */   878,  878,  878,  657,  652,  878,  657,  653,  878,  878,
 /*   390 */   878,  878,  878,  878,  816,  630,  655,  878,  654,  656,
 /*   400 */   648,  649,  595,  878,  878,  591,  878,  878,  694,  589,
 /*   410 */   878,  878,  878,  878,  878,  878,  694,  841,  878,  878,
 /*   420 */   878,  694,  696,  846,  878,  878,  878,  878,  878,  878,
 /*   430 */   847,  848,  878,  878,  878,  878,  878,  838,  839,  878,
 /*   440 */   840,  590,  878,  878,  878,  878,  878,  878,  878,  878,
 /*   450 */   878,  878,  878,  878,  878,  878,  878,  878,  660,  878,
 /*   460 */   878,  878,  878,  878,  878,  878,  659,  878,  878,  878,
 /*   470 */   878,  878,  878,  878,  728,  878,  878,  878,  729,  878,
 /*   480 */   878,  736,  878,  878,  737,  878,  878,  878,  878,  878,
 /*   490 */   878,  734,  878,  735,  878,  878,  878,  878,  878,  878,
 /*   500 */   878,  878,  878,  878,  878,  878,  878,  878,  878,  878,
 /*   510 */   878,  878,  659,  878,  878,  878,  878,  878,  878,  878,
 /*   520 */   736,  878,  878,  878,  878,  878,  878,  878,  878,  878,
 /*   530 */   694,  878,  835,  878,  878,  878,  878,  878,  878,  878,
 /*   540 */   869,  878,  878,  878,  878,  878,  878,  878,  878,  868,
 /*   550 */   869,  878,  878,  878,  878,  878,  878,  878,  878,  878,
 /*   560 */   878,  878,  878,  876,  878,  878,  877,  576,  571,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*    CASCADE => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*       GLOB => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*       LIKE => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*  STATEMENT => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
   26,  /*    REINDEX => ID */
   26,  /*     RENAME => ID */
   26,  /*      CDATE => ID */
   26,  /*      CTIME => ID */
   26,  /* CTIMESTAMP => ID */
   26,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ASC",           "ATTACH",        "BEFORE",      
  "CASCADE",       "CONFLICT",      "DATABASE",      "DESC",        
  "DETACH",        "EACH",          "FAIL",          "FOR",         
  "GLOB",          "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "REINDEX",       "RENAME",      
  "CDATE",         "CTIME",         "CTIMESTAMP",    "ALTER",       
  "OR",            "AND",           "NOT",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "EXISTS",        "CASE",        
  "WHEN",          "THEN",          "ELSE",          "INDEX",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "dbnm",          "columnlist",    "conslist_opt",  "select",      
  "column",        "columnid",      "type",          "carglist",    
  "id",            "ids",           "typename",      "signed",      
  "plus_num",      "minus_num",     "carg",          "ccons",       
  "term",          "onconf",        "sortorder",     "autoinc",     
  "expr",          "idxlist_opt",   "refargs",       "defer_subclause",
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tcons",         "idxlist",       "defer_subclause_opt",  "orconf",      
  "resolvetype",   "raisetype",     "fullname",      "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "likeop",      
  "escape",        "between_op",    "in_op",         "case_operand",
  "case_exprlist",  "case_else",     "expritem",      "uniqueflag",  
  "idxitem",       "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT term",
 /*  48 */ "carg ::= DEFAULT PLUS term",
 /*  49 */ "carg ::= DEFAULT MINUS term",
 /*  50 */ "carg ::= DEFAULT id",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "autoinc ::=",
 /*  60 */ "autoinc ::= AUTOINCR",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= raisetype",
 /*  93 */ "resolvetype ::= IGNORE",
 /*  94 */ "resolvetype ::= REPLACE",
 /*  95 */ "cmd ::= DROP TABLE fullname",
 /*  96 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  97 */ "cmd ::= DROP VIEW fullname",
 /*  98 */ "cmd ::= select",
 /*  99 */ "select ::= oneselect",
 /* 100 */ "select ::= select multiselect_op oneselect",
 /* 101 */ "multiselect_op ::= UNION",
 /* 102 */ "multiselect_op ::= UNION ALL",
 /* 103 */ "multiselect_op ::= INTERSECT",
 /* 104 */ "multiselect_op ::= EXCEPT",
 /* 105 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 106 */ "distinct ::= DISTINCT",
 /* 107 */ "distinct ::= ALL",
 /* 108 */ "distinct ::=",
 /* 109 */ "sclp ::= selcollist COMMA",
 /* 110 */ "sclp ::=",
 /* 111 */ "selcollist ::= sclp expr as",
 /* 112 */ "selcollist ::= sclp STAR",
 /* 113 */ "selcollist ::= sclp nm DOT STAR",
 /* 114 */ "as ::= AS nm",
 /* 115 */ "as ::= ids",
 /* 116 */ "as ::=",
 /* 117 */ "from ::=",
 /* 118 */ "from ::= FROM seltablist",
 /* 119 */ "stl_prefix ::= seltablist joinop",
 /* 120 */ "stl_prefix ::=",
 /* 121 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 122 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 123 */ "seltablist_paren ::= select",
 /* 124 */ "seltablist_paren ::= seltablist",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "fullname ::= nm dbnm",
 /* 128 */ "joinop ::= COMMA",
 /* 129 */ "joinop ::= JOIN",
 /* 130 */ "joinop ::= JOIN_KW JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 133 */ "on_opt ::= ON expr",
 /* 134 */ "on_opt ::=",
 /* 135 */ "using_opt ::= USING LP inscollist RP",
 /* 136 */ "using_opt ::=",
 /* 137 */ "orderby_opt ::=",
 /* 138 */ "orderby_opt ::= ORDER BY sortlist",
 /* 139 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 140 */ "sortlist ::= sortitem collate sortorder",
 /* 141 */ "sortitem ::= expr",
 /* 142 */ "sortorder ::= ASC",
 /* 143 */ "sortorder ::= DESC",
 /* 144 */ "sortorder ::=",
 /* 145 */ "collate ::=",
 /* 146 */ "collate ::= COLLATE id",
 /* 147 */ "groupby_opt ::=",
 /* 148 */ "groupby_opt ::= GROUP BY exprlist",
 /* 149 */ "having_opt ::=",
 /* 150 */ "having_opt ::= HAVING expr",
 /* 151 */ "limit_opt ::=",
 /* 152 */ "limit_opt ::= LIMIT expr",
 /* 153 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 154 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 155 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 156 */ "where_opt ::=",
 /* 157 */ "where_opt ::= WHERE expr",
 /* 158 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 159 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 160 */ "setlist ::= nm EQ expr",
 /* 161 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 162 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 163 */ "insert_cmd ::= INSERT orconf",
 /* 164 */ "insert_cmd ::= REPLACE",
 /* 165 */ "itemlist ::= itemlist COMMA expr",
 /* 166 */ "itemlist ::= expr",
 /* 167 */ "inscollist_opt ::=",
 /* 168 */ "inscollist_opt ::= LP inscollist RP",
 /* 169 */ "inscollist ::= inscollist COMMA nm",
 /* 170 */ "inscollist ::= nm",
 /* 171 */ "expr ::= term",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "term ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "term ::= INTEGER",
 /* 179 */ "term ::= FLOAT",
 /* 180 */ "term ::= STRING",
 /* 181 */ "term ::= BLOB",
 /* 182 */ "expr ::= REGISTER",
 /* 183 */ "expr ::= VARIABLE",
 /* 184 */ "expr ::= ID LP exprlist RP",
 /* 185 */ "expr ::= ID LP STAR RP",
 /* 186 */ "term ::= CTIME",
 /* 187 */ "term ::= CDATE",
 /* 188 */ "term ::= CTIMESTAMP",
 /* 189 */ "expr ::= expr AND expr",
 /* 190 */ "expr ::= expr OR expr",
 /* 191 */ "expr ::= expr LT expr",
 /* 192 */ "expr ::= expr GT expr",
 /* 193 */ "expr ::= expr LE expr",
 /* 194 */ "expr ::= expr GE expr",
 /* 195 */ "expr ::= expr NE expr",
 /* 196 */ "expr ::= expr EQ expr",
 /* 197 */ "expr ::= expr BITAND expr",
 /* 198 */ "expr ::= expr BITOR expr",
 /* 199 */ "expr ::= expr LSHIFT expr",
 /* 200 */ "expr ::= expr RSHIFT expr",
 /* 201 */ "expr ::= expr PLUS expr",
 /* 202 */ "expr ::= expr MINUS expr",
 /* 203 */ "expr ::= expr STAR expr",
 /* 204 */ "expr ::= expr SLASH expr",
 /* 205 */ "expr ::= expr REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "likeop ::= LIKE",
 /* 208 */ "likeop ::= GLOB",
 /* 209 */ "likeop ::= NOT LIKE",
 /* 210 */ "likeop ::= NOT GLOB",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOTNULL",
 /* 217 */ "expr ::= expr NOT NULL",
 /* 218 */ "expr ::= expr IS NOT NULL",
 /* 219 */ "expr ::= NOT expr",
 /* 220 */ "expr ::= BITNOT expr",
 /* 221 */ "expr ::= MINUS expr",
 /* 222 */ "expr ::= PLUS expr",
 /* 223 */ "between_op ::= BETWEEN",
 /* 224 */ "between_op ::= NOT BETWEEN",
 /* 225 */ "expr ::= expr between_op expr AND expr",
 /* 226 */ "in_op ::= IN",
 /* 227 */ "in_op ::= NOT IN",
 /* 228 */ "expr ::= expr in_op LP exprlist RP",
 /* 229 */ "expr ::= LP select RP",
 /* 230 */ "expr ::= expr in_op LP select RP",
 /* 231 */ "expr ::= expr in_op nm dbnm",
 /* 232 */ "expr ::= EXISTS LP select RP",
 /* 233 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 234 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 235 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 236 */ "case_else ::= ELSE expr",
 /* 237 */ "case_else ::=",
 /* 238 */ "case_operand ::= expr",
 /* 239 */ "case_operand ::=",
 /* 240 */ "exprlist ::= exprlist COMMA expritem",
 /* 241 */ "exprlist ::= expritem",
 /* 242 */ "expritem ::= expr",
 /* 243 */ "expritem ::=",
 /* 244 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 245 */ "uniqueflag ::= UNIQUE",
 /* 246 */ "uniqueflag ::=",
 /* 247 */ "idxlist_opt ::=",
 /* 248 */ "idxlist_opt ::= LP idxlist RP",
 /* 249 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 250 */ "idxlist ::= idxitem collate sortorder",
 /* 251 */ "idxitem ::= nm",
 /* 252 */ "cmd ::= DROP INDEX fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 257 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 260 */ "cmd ::= PRAGMA nm dbnm",
 /* 261 */ "plus_num ::= plus_opt number",
 /* 262 */ "minus_num ::= MINUS number",
 /* 263 */ "number ::= INTEGER",
 /* 264 */ "number ::= FLOAT",
 /* 265 */ "plus_opt ::= PLUS",
 /* 266 */ "plus_opt ::=",
 /* 267 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 268 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 269 */ "trigger_time ::= BEFORE",
 /* 270 */ "trigger_time ::= AFTER",
 /* 271 */ "trigger_time ::= INSTEAD OF",
 /* 272 */ "trigger_time ::=",
 /* 273 */ "trigger_event ::= DELETE",
 /* 274 */ "trigger_event ::= INSERT",
 /* 275 */ "trigger_event ::= UPDATE",
 /* 276 */ "trigger_event ::= UPDATE OF inscollist",
 /* 277 */ "foreach_clause ::=",
 /* 278 */ "foreach_clause ::= FOR EACH ROW",
 /* 279 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 280 */ "when_clause ::=",
 /* 281 */ "when_clause ::= WHEN expr",
 /* 282 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 283 */ "trigger_cmd_list ::=",
 /* 284 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 285 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 286 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 287 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 288 */ "trigger_cmd ::= select",
 /* 289 */ "expr ::= RAISE LP IGNORE RP",
 /* 290 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 291 */ "raisetype ::= ROLLBACK",
 /* 292 */ "raisetype ::= ABORT",
 /* 293 */ "raisetype ::= FAIL",
 /* 294 */ "cmd ::= DROP TRIGGER fullname",
 /* 295 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 296 */ "key_opt ::=",
 /* 297 */ "key_opt ::= KEY ids",
 /* 298 */ "key_opt ::= KEY BLOB",
 /* 299 */ "database_kw_opt ::= DATABASE",
 /* 300 */ "database_kw_opt ::=",
 /* 301 */ "cmd ::= DETACH database_kw_opt nm",
 /* 302 */ "cmd ::= REINDEX",
 /* 303 */ "cmd ::= REINDEX nm dbnm",
 /* 304 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 305 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 306 */ "add_column_fullname ::= fullname",
 /* 307 */ "kwcolumn_opt ::=",
 /* 308 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 159:
    case 191:
    case 208:
#line 332 "parse.y"
{sqlite3SelectDelete((yypminor->yy91));}
#line 1322 "parse.c"
      break;
    case 172:
    case 176:
    case 196:
    case 198:
    case 206:
    case 212:
    case 226:
#line 591 "parse.y"
{sqlite3ExprDelete((yypminor->yy418));}
#line 1333 "parse.c"
      break;
    case 177:
    case 185:
    case 194:
    case 197:
    case 199:
    case 201:
    case 211:
    case 214:
    case 215:
    case 218:
    case 224:
#line 810 "parse.y"
{sqlite3ExprListDelete((yypminor->yy322));}
#line 1348 "parse.c"
      break;
    case 190:
    case 195:
    case 203:
    case 204:
#line 461 "parse.y"
{sqlite3SrcListDelete((yypminor->yy439));}
#line 1356 "parse.c"
      break;
    case 200:
#line 523 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy388).pLimit);
  sqlite3ExprDelete((yypminor->yy388).pOffset);
}
#line 1364 "parse.c"
      break;
    case 207:
    case 210:
    case 217:
#line 479 "parse.y"
{sqlite3IdListDelete((yypminor->yy232));}
#line 1371 "parse.c"
      break;
    case 232:
    case 237:
#line 903 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy451));}
#line 1377 "parse.c"
      break;
    case 234:
#line 887 "parse.y"
{sqlite3IdListDelete((yypminor->yy378).b);}
#line 1382 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 144, 1 },
  { 145, 2 },
  { 145, 1 },
  { 147, 1 },
  { 146, 1 },
  { 146, 3 },
  { 149, 0 },
  { 149, 1 },
  { 148, 3 },
  { 151, 0 },
  { 151, 1 },
  { 151, 2 },
  { 150, 0 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 148, 2 },
  { 148, 2 },
  { 148, 2 },
  { 148, 2 },
  { 153, 5 },
  { 155, 1 },
  { 155, 0 },
  { 154, 4 },
  { 154, 2 },
  { 157, 3 },
  { 157, 1 },
  { 160, 3 },
  { 161, 1 },
  { 164, 1 },
  { 165, 1 },
  { 165, 1 },
  { 152, 1 },
  { 152, 1 },
  { 152, 1 },
  { 162, 0 },
  { 162, 1 },
  { 162, 4 },
  { 162, 6 },
  { 166, 1 },
  { 166, 2 },
  { 167, 1 },
  { 167, 1 },
  { 163, 2 },
  { 163, 0 },
  { 170, 3 },
  { 170, 1 },
  { 170, 2 },
  { 170, 3 },
  { 170, 3 },
  { 170, 2 },
  { 171, 2 },
  { 171, 3 },
  { 171, 5 },
  { 171, 2 },
  { 171, 5 },
  { 171, 4 },
  { 171, 1 },
  { 171, 2 },
  { 175, 0 },
  { 175, 1 },
  { 178, 0 },
  { 178, 2 },
  { 180, 2 },
  { 180, 3 },
  { 180, 3 },
  { 180, 3 },
  { 181, 2 },
  { 181, 2 },
  { 181, 1 },
  { 181, 1 },
  { 179, 3 },
  { 179, 2 },
  { 182, 0 },
  { 182, 2 },
  { 182, 2 },
  { 158, 0 },
  { 158, 2 },
  { 183, 3 },
  { 183, 2 },
  { 183, 1 },
  { 184, 2 },
  { 184, 7 },
  { 184, 5 },
  { 184, 3 },
  { 184, 10 },
  { 186, 0 },
  { 186, 1 },
  { 173, 0 },
  { 173, 3 },
  { 187, 0 },
  { 187, 2 },
  { 188, 1 },
  { 188, 1 },
  { 188, 1 },
  { 148, 3 },
  { 148, 7 },
  { 148, 3 },
  { 148, 1 },
  { 159, 1 },
  { 159, 3 },
  { 192, 1 },
  { 192, 2 },
  { 192, 1 },
  { 192, 1 },
  { 191, 9 },
  { 193, 1 },
  { 193, 1 },
  { 193, 0 },
  { 201, 2 },
  { 201, 0 },
  { 194, 3 },
  { 194, 2 },
  { 194, 4 },
  { 202, 2 },
  { 202, 1 },
  { 202, 0 },
  { 195, 0 },
  { 195, 2 },
  { 204, 2 },
  { 204, 0 },
  { 203, 6 },
  { 203, 7 },
  { 208, 1 },
  { 208, 1 },
  { 156, 0 },
  { 156, 2 },
  { 190, 2 },
  { 205, 1 },
  { 205, 1 },
  { 205, 2 },
  { 205, 3 },
  { 205, 4 },
  { 206, 2 },
  { 206, 0 },
  { 207, 4 },
  { 207, 0 },
  { 199, 0 },
  { 199, 3 },
  { 211, 5 },
  { 211, 3 },
  { 212, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 0 },
  { 213, 0 },
  { 213, 2 },
  { 197, 0 },
  { 197, 3 },
  { 198, 0 },
  { 198, 2 },
  { 200, 0 },
  { 200, 2 },
  { 200, 4 },
  { 200, 4 },
  { 148, 4 },
  { 196, 0 },
  { 196, 2 },
  { 148, 6 },
  { 215, 5 },
  { 215, 3 },
  { 148, 8 },
  { 148, 5 },
  { 216, 2 },
  { 216, 1 },
  { 218, 3 },
  { 218, 1 },
  { 217, 0 },
  { 217, 3 },
  { 210, 3 },
  { 210, 1 },
  { 176, 1 },
  { 176, 3 },
  { 172, 1 },
  { 176, 1 },
  { 176, 1 },
  { 176, 3 },
  { 176, 5 },
  { 172, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 1 },
  { 176, 1 },
  { 176, 1 },
  { 176, 4 },
  { 176, 4 },
  { 172, 1 },
  { 172, 1 },
  { 172, 1 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 176, 3 },
  { 219, 1 },
  { 219, 1 },
  { 219, 2 },
  { 219, 2 },
  { 220, 2 },
  { 220, 0 },
  { 176, 4 },
  { 176, 2 },
  { 176, 3 },
  { 176, 2 },
  { 176, 3 },
  { 176, 4 },
  { 176, 2 },
  { 176, 2 },
  { 176, 2 },
  { 176, 2 },
  { 221, 1 },
  { 221, 2 },
  { 176, 5 },
  { 222, 1 },
  { 222, 2 },
  { 176, 5 },
  { 176, 3 },
  { 176, 5 },
  { 176, 4 },
  { 176, 4 },
  { 176, 5 },
  { 224, 5 },
  { 224, 4 },
  { 225, 2 },
  { 225, 0 },
  { 223, 1 },
  { 223, 0 },
  { 214, 3 },
  { 214, 1 },
  { 226, 1 },
  { 226, 0 },
  { 148, 11 },
  { 227, 1 },
  { 227, 0 },
  { 177, 0 },
  { 177, 3 },
  { 185, 5 },
  { 185, 3 },
  { 228, 1 },
  { 148, 3 },
  { 148, 1 },
  { 148, 2 },
  { 148, 5 },
  { 148, 5 },
  { 148, 5 },
  { 148, 5 },
  { 148, 6 },
  { 148, 3 },
  { 168, 2 },
  { 169, 2 },
  { 230, 1 },
  { 230, 1 },
  { 229, 1 },
  { 229, 0 },
  { 148, 5 },
  { 231, 10 },
  { 233, 1 },
  { 233, 1 },
  { 233, 2 },
  { 233, 0 },
  { 234, 1 },
  { 234, 1 },
  { 234, 1 },
  { 234, 3 },
  { 235, 0 },
  { 235, 3 },
  { 235, 3 },
  { 236, 0 },
  { 236, 2 },
  { 232, 3 },
  { 232, 0 },
  { 237, 6 },
  { 237, 8 },
  { 237, 5 },
  { 237, 4 },
  { 237, 1 },
  { 176, 4 },
  { 176, 6 },
  { 189, 1 },
  { 189, 1 },
  { 189, 1 },
  { 148, 3 },
  { 148, 6 },
  { 239, 0 },
  { 239, 2 },
  { 239, 2 },
  { 238, 1 },
  { 238, 0 },
  { 148, 3 },
  { 148, 1 },
  { 148, 3 },
  { 148, 6 },
  { 148, 6 },
  { 240, 1 },
  { 241, 0 },
  { 241, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 84 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1918 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1923 "parse.c"
        break;
      case 7:
#line 89 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1928 "parse.c"
        break;
      case 8:
#line 95 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy328);}
#line 1933 "parse.c"
        break;
      case 12:
#line 100 "parse.y"
{yygotominor.yy328 = TK_DEFERRED;}
#line 1938 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 101:
      case 103:
      case 104:
#line 101 "parse.y"
{yygotominor.yy328 = yymsp[0].major;}
#line 1948 "parse.c"
        break;
      case 16:
      case 17:
#line 104 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1954 "parse.c"
        break;
      case 18:
#line 106 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1959 "parse.c"
        break;
      case 20:
#line 111 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy430,&yymsp[0].minor.yy430,yymsp[-3].minor.yy328,0);
}
#line 1966 "parse.c"
        break;
      case 21:
      case 60:
      case 74:
      case 106:
      case 224:
      case 227:
#line 115 "parse.y"
{yygotominor.yy328 = 1;}
#line 1976 "parse.c"
        break;
      case 22:
      case 59:
      case 73:
      case 75:
      case 86:
      case 107:
      case 108:
      case 223:
      case 226:
#line 116 "parse.y"
{yygotominor.yy328 = 0;}
#line 1989 "parse.c"
        break;
      case 23:
#line 117 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy430,&yymsp[0].minor.yy0,0);
}
#line 1996 "parse.c"
        break;
      case 24:
#line 120 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy91);
  sqlite3SelectDelete(yymsp[0].minor.yy91);
}
#line 2004 "parse.c"
        break;
      case 27:
#line 131 "parse.y"
{
  yygotominor.yy430.z = yymsp[-2].minor.yy430.z;
  yygotominor.yy430.n = (pParse->sLastToken.z-yymsp[-2].minor.yy430.z) + pParse->sLastToken.n;
}
#line 2012 "parse.c"
        break;
      case 28:
#line 135 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy430);
  yygotominor.yy430 = yymsp[0].minor.yy430;
}
#line 2020 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 263:
      case 264:
#line 145 "parse.y"
{yygotominor.yy430 = yymsp[0].minor.yy0;}
#line 2032 "parse.c"
        break;
      case 36:
#line 200 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy430,&yymsp[0].minor.yy430);}
#line 2037 "parse.c"
        break;
      case 37:
#line 201 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy430,&yymsp[0].minor.yy0);}
#line 2042 "parse.c"
        break;
      case 38:
#line 203 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy430,&yymsp[0].minor.yy0);}
#line 2047 "parse.c"
        break;
      case 39:
      case 114:
      case 115:
      case 126:
      case 146:
      case 251:
      case 261:
      case 262:
#line 205 "parse.y"
{yygotominor.yy430 = yymsp[0].minor.yy430;}
#line 2059 "parse.c"
        break;
      case 40:
#line 206 "parse.y"
{yygotominor.yy430.z=yymsp[-1].minor.yy430.z; yygotominor.yy430.n=yymsp[0].minor.yy430.n+(yymsp[0].minor.yy430.z-yymsp[-1].minor.yy430.z);}
#line 2064 "parse.c"
        break;
      case 41:
#line 208 "parse.y"
{ yygotominor.yy328 = atoi(yymsp[0].minor.yy430.z); }
#line 2069 "parse.c"
        break;
      case 42:
#line 209 "parse.y"
{ yygotominor.yy328 = -atoi(yymsp[0].minor.yy430.z); }
#line 2074 "parse.c"
        break;
      case 47:
      case 48:
#line 214 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy418);}
#line 2080 "parse.c"
        break;
      case 49:
#line 216 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy418, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2088 "parse.c"
        break;
      case 50:
#line 220 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy430);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2096 "parse.c"
        break;
      case 52:
#line 229 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy328);}
#line 2101 "parse.c"
        break;
      case 53:
#line 231 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy328,yymsp[0].minor.yy328);}
#line 2106 "parse.c"
        break;
      case 54:
#line 232 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy328,0,0);}
#line 2111 "parse.c"
        break;
      case 55:
#line 233 "parse.y"
{sqlite3ExprDelete(yymsp[-2].minor.yy418);}
#line 2116 "parse.c"
        break;
      case 56:
#line 235 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy430,yymsp[-1].minor.yy322,yymsp[0].minor.yy328);}
#line 2121 "parse.c"
        break;
      case 57:
#line 236 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy328);}
#line 2126 "parse.c"
        break;
      case 58:
#line 237 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy430.z, yymsp[0].minor.yy430.n);}
#line 2131 "parse.c"
        break;
      case 61:
#line 250 "parse.y"
{ yygotominor.yy328 = OE_Restrict * 0x010101; }
#line 2136 "parse.c"
        break;
      case 62:
#line 251 "parse.y"
{ yygotominor.yy328 = (yymsp[-1].minor.yy328 & yymsp[0].minor.yy319.mask) | yymsp[0].minor.yy319.value; }
#line 2141 "parse.c"
        break;
      case 63:
#line 253 "parse.y"
{ yygotominor.yy319.value = 0;     yygotominor.yy319.mask = 0x000000; }
#line 2146 "parse.c"
        break;
      case 64:
#line 254 "parse.y"
{ yygotominor.yy319.value = yymsp[0].minor.yy328;     yygotominor.yy319.mask = 0x0000ff; }
#line 2151 "parse.c"
        break;
      case 65:
#line 255 "parse.y"
{ yygotominor.yy319.value = yymsp[0].minor.yy328<<8;  yygotominor.yy319.mask = 0x00ff00; }
#line 2156 "parse.c"
        break;
      case 66:
#line 256 "parse.y"
{ yygotominor.yy319.value = yymsp[0].minor.yy328<<16; yygotominor.yy319.mask = 0xff0000; }
#line 2161 "parse.c"
        break;
      case 67:
#line 258 "parse.y"
{ yygotominor.yy328 = OE_SetNull; }
#line 2166 "parse.c"
        break;
      case 68:
#line 259 "parse.y"
{ yygotominor.yy328 = OE_SetDflt; }
#line 2171 "parse.c"
        break;
      case 69:
#line 260 "parse.y"
{ yygotominor.yy328 = OE_Cascade; }
#line 2176 "parse.c"
        break;
      case 70:
#line 261 "parse.y"
{ yygotominor.yy328 = OE_Restrict; }
#line 2181 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 89:
      case 91:
      case 92:
      case 163:
#line 263 "parse.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;}
#line 2192 "parse.c"
        break;
      case 76:
#line 273 "parse.y"
{yygotominor.yy430.n = 0; yygotominor.yy430.z = 0;}
#line 2197 "parse.c"
        break;
      case 77:
#line 274 "parse.y"
{yygotominor.yy430 = yymsp[-1].minor.yy0;}
#line 2202 "parse.c"
        break;
      case 82:
#line 280 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy322,yymsp[0].minor.yy328,yymsp[-2].minor.yy328);}
#line 2207 "parse.c"
        break;
      case 83:
#line 282 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy322,yymsp[0].minor.yy328,0,0);}
#line 2212 "parse.c"
        break;
      case 85:
#line 285 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy322, &yymsp[-3].minor.yy430, yymsp[-2].minor.yy322, yymsp[-1].minor.yy328);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy328);
}
#line 2220 "parse.c"
        break;
      case 88:
      case 90:
#line 299 "parse.y"
{yygotominor.yy328 = OE_Default;}
#line 2226 "parse.c"
        break;
      case 93:
#line 304 "parse.y"
{yygotominor.yy328 = OE_Ignore;}
#line 2231 "parse.c"
        break;
      case 94:
      case 164:
#line 305 "parse.y"
{yygotominor.yy328 = OE_Replace;}
#line 2237 "parse.c"
        break;
      case 95:
#line 309 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy439, 0);
}
#line 2244 "parse.c"
        break;
      case 96:
#line 316 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy430, &yymsp[-2].minor.yy430, yymsp[0].minor.yy91, yymsp[-5].minor.yy328);
}
#line 2251 "parse.c"
        break;
      case 97:
#line 319 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy439, 1);
}
#line 2258 "parse.c"
        break;
      case 98:
#line 326 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy91, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy91);
}
#line 2266 "parse.c"
        break;
      case 99:
      case 123:
#line 336 "parse.y"
{yygotominor.yy91 = yymsp[0].minor.yy91;}
#line 2272 "parse.c"
        break;
      case 100:
#line 338 "parse.y"
{
  if( yymsp[0].minor.yy91 ){
    yymsp[0].minor.yy91->op = yymsp[-1].minor.yy328;
    yymsp[0].minor.yy91->pPrior = yymsp[-2].minor.yy91;
  }
  yygotominor.yy91 = yymsp[0].minor.yy91;
}
#line 2283 "parse.c"
        break;
      case 102:
#line 347 "parse.y"
{yygotominor.yy328 = TK_ALL;}
#line 2288 "parse.c"
        break;
      case 105:
#line 352 "parse.y"
{
  yygotominor.yy91 = sqlite3SelectNew(yymsp[-6].minor.yy322,yymsp[-5].minor.yy439,yymsp[-4].minor.yy418,yymsp[-3].minor.yy322,yymsp[-2].minor.yy418,yymsp[-1].minor.yy322,yymsp[-7].minor.yy328,yymsp[0].minor.yy388.pLimit,yymsp[0].minor.yy388.pOffset);
}
#line 2295 "parse.c"
        break;
      case 109:
      case 248:
#line 373 "parse.y"
{yygotominor.yy322 = yymsp[-1].minor.yy322;}
#line 2301 "parse.c"
        break;
      case 110:
      case 137:
      case 147:
      case 247:
#line 374 "parse.y"
{yygotominor.yy322 = 0;}
#line 2309 "parse.c"
        break;
      case 111:
#line 375 "parse.y"
{
   yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-2].minor.yy322,yymsp[-1].minor.yy418,yymsp[0].minor.yy430.n?&yymsp[0].minor.yy430:0);
}
#line 2316 "parse.c"
        break;
      case 112:
#line 378 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-1].minor.yy322, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2323 "parse.c"
        break;
      case 113:
#line 381 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy430);
  yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-3].minor.yy322, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2332 "parse.c"
        break;
      case 116:
#line 393 "parse.y"
{yygotominor.yy430.n = 0;}
#line 2337 "parse.c"
        break;
      case 117:
#line 405 "parse.y"
{yygotominor.yy439 = sqliteMalloc(sizeof(*yygotominor.yy439));}
#line 2342 "parse.c"
        break;
      case 118:
#line 406 "parse.y"
{yygotominor.yy439 = yymsp[0].minor.yy439;}
#line 2347 "parse.c"
        break;
      case 119:
#line 411 "parse.y"
{
   yygotominor.yy439 = yymsp[-1].minor.yy439;
   if( yygotominor.yy439 && yygotominor.yy439->nSrc>0 ) yygotominor.yy439->a[yygotominor.yy439->nSrc-1].jointype = yymsp[0].minor.yy328;
}
#line 2355 "parse.c"
        break;
      case 120:
#line 415 "parse.y"
{yygotominor.yy439 = 0;}
#line 2360 "parse.c"
        break;
      case 121:
#line 416 "parse.y"
{
  yygotominor.yy439 = sqlite3SrcListAppend(yymsp[-5].minor.yy439,&yymsp[-4].minor.yy430,&yymsp[-3].minor.yy430);
  if( yymsp[-2].minor.yy430.n ) sqlite3SrcListAddAlias(yygotominor.yy439,&yymsp[-2].minor.yy430);
  if( yymsp[-1].minor.yy418 ){
    if( yygotominor.yy439 && yygotominor.yy439->nSrc>1 ){ yygotominor.yy439->a[yygotominor.yy439->nSrc-2].pOn = yymsp[-1].minor.yy418; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy418); }
  }
  if( yymsp[0].minor.yy232 ){
    if( yygotominor.yy439 && yygotominor.yy439->nSrc>1 ){ yygotominor.yy439->a[yygotominor.yy439->nSrc-2].pUsing = yymsp[0].minor.yy232; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy232); }
  }
}
#line 2376 "parse.c"
        break;
      case 122:
#line 430 "parse.y"
{
    yygotominor.yy439 = sqlite3SrcListAppend(yymsp[-6].minor.yy439,0,0);
    yygotominor.yy439->a[yygotominor.yy439->nSrc-1].pSelect = yymsp[-4].minor.yy91;
    if( yymsp[-2].minor.yy430.n ) sqlite3SrcListAddAlias(yygotominor.yy439,&yymsp[-2].minor.yy430);
    if( yymsp[-1].minor.yy418 ){
      if( yygotominor.yy439 && yygotominor.yy439->nSrc>1 ){ yygotominor.yy439->a[yygotominor.yy439->nSrc-2].pOn = yymsp[-1].minor.yy418; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy418); }
    }
    if( yymsp[0].minor.yy232 ){
      if( yygotominor.yy439 && yygotominor.yy439->nSrc>1 ){ yygotominor.yy439->a[yygotominor.yy439->nSrc-2].pUsing = yymsp[0].minor.yy232; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy232); }
    }
  }
#line 2393 "parse.c"
        break;
      case 124:
#line 451 "parse.y"
{
     yygotominor.yy91 = sqlite3SelectNew(0,yymsp[0].minor.yy439,0,0,0,0,0,0,0);
  }
#line 2400 "parse.c"
        break;
      case 125:
#line 457 "parse.y"
{yygotominor.yy430.z=0; yygotominor.yy430.n=0;}
#line 2405 "parse.c"
        break;
      case 127:
#line 462 "parse.y"
{yygotominor.yy439 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy430,&yymsp[0].minor.yy430);}
#line 2410 "parse.c"
        break;
      case 128:
      case 129:
#line 466 "parse.y"
{ yygotominor.yy328 = JT_INNER; }
#line 2416 "parse.c"
        break;
      case 130:
#line 468 "parse.y"
{ yygotominor.yy328 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2421 "parse.c"
        break;
      case 131:
#line 469 "parse.y"
{ yygotominor.yy328 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy430,0); }
#line 2426 "parse.c"
        break;
      case 132:
#line 471 "parse.y"
{ yygotominor.yy328 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy430,&yymsp[-1].minor.yy430); }
#line 2431 "parse.c"
        break;
      case 133:
      case 141:
      case 150:
      case 157:
      case 171:
      case 211:
      case 236:
      case 238:
      case 242:
#line 475 "parse.y"
{yygotominor.yy418 = yymsp[0].minor.yy418;}
#line 2444 "parse.c"
        break;
      case 134:
      case 149:
      case 156:
      case 212:
      case 237:
      case 239:
      case 243:
#line 476 "parse.y"
{yygotominor.yy418 = 0;}
#line 2455 "parse.c"
        break;
      case 135:
      case 168:
#line 480 "parse.y"
{yygotominor.yy232 = yymsp[-1].minor.yy232;}
#line 2461 "parse.c"
        break;
      case 136:
      case 167:
#line 481 "parse.y"
{yygotominor.yy232 = 0;}
#line 2467 "parse.c"
        break;
      case 138:
      case 148:
#line 492 "parse.y"
{yygotominor.yy322 = yymsp[0].minor.yy322;}
#line 2473 "parse.c"
        break;
      case 139:
#line 493 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-4].minor.yy322,yymsp[-2].minor.yy418,yymsp[-1].minor.yy430.n>0?&yymsp[-1].minor.yy430:0);
  if( yygotominor.yy322 ) yygotominor.yy322->a[yygotominor.yy322->nExpr-1].sortOrder = yymsp[0].minor.yy328;
}
#line 2481 "parse.c"
        break;
      case 140:
#line 497 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy418,yymsp[-1].minor.yy430.n>0?&yymsp[-1].minor.yy430:0);
  if( yygotominor.yy322 && yygotominor.yy322->a ) yygotominor.yy322->a[0].sortOrder = yymsp[0].minor.yy328;
}
#line 2489 "parse.c"
        break;
      case 142:
      case 144:
#line 506 "parse.y"
{yygotominor.yy328 = SQLITE_SO_ASC;}
#line 2495 "parse.c"
        break;
      case 143:
#line 507 "parse.y"
{yygotominor.yy328 = SQLITE_SO_DESC;}
#line 2500 "parse.c"
        break;
      case 145:
#line 509 "parse.y"
{yygotominor.yy430.z = 0; yygotominor.yy430.n = 0;}
#line 2505 "parse.c"
        break;
      case 151:
#line 527 "parse.y"
{yygotominor.yy388.pLimit = 0; yygotominor.yy388.pOffset = 0;}
#line 2510 "parse.c"
        break;
      case 152:
#line 528 "parse.y"
{yygotominor.yy388.pLimit = yymsp[0].minor.yy418; yygotominor.yy388.pOffset = 0;}
#line 2515 "parse.c"
        break;
      case 153:
#line 530 "parse.y"
{yygotominor.yy388.pLimit = yymsp[-2].minor.yy418; yygotominor.yy388.pOffset = yymsp[0].minor.yy418;}
#line 2520 "parse.c"
        break;
      case 154:
#line 532 "parse.y"
{yygotominor.yy388.pOffset = yymsp[-2].minor.yy418; yygotominor.yy388.pLimit = yymsp[0].minor.yy418;}
#line 2525 "parse.c"
        break;
      case 155:
#line 536 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy439,yymsp[0].minor.yy418);}
#line 2530 "parse.c"
        break;
      case 158:
#line 550 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy439,yymsp[-1].minor.yy322,yymsp[0].minor.yy418,yymsp[-4].minor.yy328);}
#line 2535 "parse.c"
        break;
      case 159:
#line 553 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-4].minor.yy322,yymsp[0].minor.yy418,&yymsp[-2].minor.yy430);}
#line 2540 "parse.c"
        break;
      case 160:
#line 554 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(0,yymsp[0].minor.yy418,&yymsp[-2].minor.yy430);}
#line 2545 "parse.c"
        break;
      case 161:
#line 560 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy439, yymsp[-1].minor.yy322, 0, yymsp[-4].minor.yy232, yymsp[-7].minor.yy328);}
#line 2550 "parse.c"
        break;
      case 162:
#line 562 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy439, 0, yymsp[0].minor.yy91, yymsp[-1].minor.yy232, yymsp[-4].minor.yy328);}
#line 2555 "parse.c"
        break;
      case 165:
      case 240:
#line 572 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-2].minor.yy322,yymsp[0].minor.yy418,0);}
#line 2561 "parse.c"
        break;
      case 166:
      case 241:
#line 573 "parse.y"
{yygotominor.yy322 = sqlite3ExprListAppend(0,yymsp[0].minor.yy418,0);}
#line 2567 "parse.c"
        break;
      case 169:
#line 582 "parse.y"
{yygotominor.yy232 = sqlite3IdListAppend(yymsp[-2].minor.yy232,&yymsp[0].minor.yy430);}
#line 2572 "parse.c"
        break;
      case 170:
#line 583 "parse.y"
{yygotominor.yy232 = sqlite3IdListAppend(0,&yymsp[0].minor.yy430);}
#line 2577 "parse.c"
        break;
      case 172:
#line 594 "parse.y"
{yygotominor.yy418 = yymsp[-1].minor.yy418; sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2582 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 595 "parse.y"
{yygotominor.yy418 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2591 "parse.c"
        break;
      case 174:
      case 175:
#line 596 "parse.y"
{yygotominor.yy418 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2597 "parse.c"
        break;
      case 176:
#line 598 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy430);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy430);
  yygotominor.yy418 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2606 "parse.c"
        break;
      case 177:
#line 603 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy430);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy430);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy430);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy418 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2617 "parse.c"
        break;
      case 182:
#line 614 "parse.y"
{yygotominor.yy418 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2622 "parse.c"
        break;
      case 183:
#line 615 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy418 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2631 "parse.c"
        break;
      case 184:
#line 620 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprFunction(yymsp[-1].minor.yy322, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2639 "parse.c"
        break;
      case 185:
#line 624 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2647 "parse.c"
        break;
      case 186:
      case 187:
      case 188:
#line 628 "parse.y"
{yygotominor.yy418 = sqlite3Expr(yymsp[0].major,0,0,0);}
#line 2654 "parse.c"
        break;
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
#line 631 "parse.y"
{yygotominor.yy418 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy418, yymsp[0].minor.yy418, 0);}
#line 2676 "parse.c"
        break;
      case 207:
#line 650 "parse.y"
{yygotominor.yy30.opcode = TK_LIKE; yygotominor.yy30.not = 0;}
#line 2681 "parse.c"
        break;
      case 208:
#line 651 "parse.y"
{yygotominor.yy30.opcode = TK_GLOB; yygotominor.yy30.not = 0;}
#line 2686 "parse.c"
        break;
      case 209:
#line 652 "parse.y"
{yygotominor.yy30.opcode = TK_LIKE; yygotominor.yy30.not = 1;}
#line 2691 "parse.c"
        break;
      case 210:
#line 653 "parse.y"
{yygotominor.yy30.opcode = TK_GLOB; yygotominor.yy30.not = 1;}
#line 2696 "parse.c"
        break;
      case 213:
#line 657 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy418, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy418, 0);
  if( yymsp[0].minor.yy418 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy418, 0);
  }
  yygotominor.yy418 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy418 ) yygotominor.yy418->op = yymsp[-2].minor.yy30.opcode;
  if( yymsp[-2].minor.yy30.not ) yygotominor.yy418 = sqlite3Expr(TK_NOT, yygotominor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418, &yymsp[-3].minor.yy418->span, &yymsp[-1].minor.yy418->span);
}
#line 2711 "parse.c"
        break;
      case 214:
#line 669 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2719 "parse.c"
        break;
      case 215:
#line 673 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2727 "parse.c"
        break;
      case 216:
#line 677 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2735 "parse.c"
        break;
      case 217:
#line 681 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2743 "parse.c"
        break;
      case 218:
#line 685 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-3].minor.yy418->span,&yymsp[0].minor.yy0);
}
#line 2751 "parse.c"
        break;
      case 219:
      case 220:
#line 689 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy418->span);
}
#line 2760 "parse.c"
        break;
      case 221:
#line 697 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy418->span);
}
#line 2768 "parse.c"
        break;
      case 222:
#line 701 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy418->span);
}
#line 2776 "parse.c"
        break;
      case 225:
#line 708 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy418, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy418, 0);
  yygotominor.yy418 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy418, 0, 0);
  if( yygotominor.yy418 ) yygotominor.yy418->pList = pList;
  if( yymsp[-3].minor.yy328 ) yygotominor.yy418 = sqlite3Expr(TK_NOT, yygotominor.yy418, 0, 0);
  sqlite3ExprSpan(yygotominor.yy418,&yymsp[-4].minor.yy418->span,&yymsp[0].minor.yy418->span);
}
#line 2788 "parse.c"
        break;
      case 228:
#line 720 "parse.y"
{
    yygotominor.yy418 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy418, 0, 0);
    if( yygotominor.yy418 ){
      yygotominor.yy418->pList = yymsp[-1].minor.yy322;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy322);
    }
    if( yymsp[-3].minor.yy328 ) yygotominor.yy418 = sqlite3Expr(TK_NOT, yygotominor.yy418, 0, 0);
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-4].minor.yy418->span,&yymsp[0].minor.yy0);
  }
#line 2802 "parse.c"
        break;
      case 229:
#line 730 "parse.y"
{
    yygotominor.yy418 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy418 ) yygotominor.yy418->pSelect = yymsp[-1].minor.yy91;
    if( !yygotominor.yy418 ) sqlite3SelectDelete(yymsp[-1].minor.yy91);
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2812 "parse.c"
        break;
      case 230:
#line 736 "parse.y"
{
    yygotominor.yy418 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy418, 0, 0);
    if( yygotominor.yy418 ) yygotominor.yy418->pSelect = yymsp[-1].minor.yy91;
    if( !yygotominor.yy418 ) sqlite3SelectDelete(yymsp[-1].minor.yy91);
    if( yymsp[-3].minor.yy328 ) yygotominor.yy418 = sqlite3Expr(TK_NOT, yygotominor.yy418, 0, 0);
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-4].minor.yy418->span,&yymsp[0].minor.yy0);
  }
#line 2823 "parse.c"
        break;
      case 231:
#line 743 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy430,&yymsp[0].minor.yy430);
    yygotominor.yy418 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy418, 0, 0);
    if( yygotominor.yy418 ) yygotominor.yy418->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    if( yymsp[-2].minor.yy328 ) yygotominor.yy418 = sqlite3Expr(TK_NOT, yygotominor.yy418, 0, 0);
    sqlite3ExprSpan(yygotominor.yy418,&yymsp[-3].minor.yy418->span,yymsp[0].minor.yy430.z?&yymsp[0].minor.yy430:&yymsp[-1].minor.yy430);
  }
#line 2834 "parse.c"
        break;
      case 232:
#line 750 "parse.y"
{
    Expr *p = yygotominor.yy418 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy91;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }
    if( !p ) sqlite3SelectDelete(yymsp[-1].minor.yy91);
  }
#line 2846 "parse.c"
        break;
      case 233:
#line 761 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy418, yymsp[-1].minor.yy418, 0);
  if( yygotominor.yy418 ) yygotominor.yy418->pList = yymsp[-2].minor.yy322;
  sqlite3ExprSpan(yygotominor.yy418, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2855 "parse.c"
        break;
      case 234:
#line 768 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-4].minor.yy322, yymsp[-2].minor.yy418, 0);
  yygotominor.yy322 = sqlite3ExprListAppend(yygotominor.yy322, yymsp[0].minor.yy418, 0);
}
#line 2863 "parse.c"
        break;
      case 235:
#line 772 "parse.y"
{
  yygotominor.yy322 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy418, 0);
  yygotominor.yy322 = sqlite3ExprListAppend(yygotominor.yy322, yymsp[0].minor.yy418, 0);
}
#line 2871 "parse.c"
        break;
      case 244:
#line 797 "parse.y"
{
  if( yymsp[-9].minor.yy328!=OE_None ) yymsp[-9].minor.yy328 = yymsp[0].minor.yy328;
  if( yymsp[-9].minor.yy328==OE_Default) yymsp[-9].minor.yy328 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy430, &yymsp[-6].minor.yy430, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy430,0),yymsp[-2].minor.yy322,yymsp[-9].minor.yy328, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2880 "parse.c"
        break;
      case 245:
      case 292:
#line 804 "parse.y"
{yygotominor.yy328 = OE_Abort;}
#line 2886 "parse.c"
        break;
      case 246:
#line 805 "parse.y"
{yygotominor.yy328 = OE_None;}
#line 2891 "parse.c"
        break;
      case 249:
#line 815 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy430.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy430.z, yymsp[-1].minor.yy430.n);
  }
  yygotominor.yy322 = sqlite3ExprListAppend(yymsp[-4].minor.yy322, p, &yymsp[-2].minor.yy430);
}
#line 2903 "parse.c"
        break;
      case 250:
#line 823 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy430.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy430.z, yymsp[-1].minor.yy430.n);
  }
  yygotominor.yy322 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy430);
}
#line 2915 "parse.c"
        break;
      case 252:
#line 836 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy439);}
#line 2920 "parse.c"
        break;
      case 253:
      case 254:
#line 840 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2926 "parse.c"
        break;
      case 255:
      case 257:
#line 846 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy430,&yymsp[-2].minor.yy430,&yymsp[0].minor.yy430,0);}
#line 2932 "parse.c"
        break;
      case 256:
#line 847 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy430,&yymsp[-2].minor.yy430,&yymsp[0].minor.yy0,0);}
#line 2937 "parse.c"
        break;
      case 258:
#line 849 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy430,&yymsp[-2].minor.yy430,&yymsp[0].minor.yy430,1);
}
#line 2944 "parse.c"
        break;
      case 259:
#line 852 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy430,&yymsp[-3].minor.yy430,&yymsp[-1].minor.yy430,0);}
#line 2949 "parse.c"
        break;
      case 260:
#line 853 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy430,&yymsp[0].minor.yy430,0,0);}
#line 2954 "parse.c"
        break;
      case 267:
#line 866 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy430.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy430.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy451, &all);
}
#line 2964 "parse.c"
        break;
      case 268:
#line 875 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy430, &yymsp[-6].minor.yy430, yymsp[-5].minor.yy328, yymsp[-4].minor.yy378.a, yymsp[-4].minor.yy378.b, yymsp[-2].minor.yy439, yymsp[-1].minor.yy328, yymsp[0].minor.yy418, yymsp[-9].minor.yy328);
  yygotominor.yy430 = (yymsp[-6].minor.yy430.n==0?yymsp[-7].minor.yy430:yymsp[-6].minor.yy430);
}
#line 2972 "parse.c"
        break;
      case 269:
      case 272:
#line 881 "parse.y"
{ yygotominor.yy328 = TK_BEFORE; }
#line 2978 "parse.c"
        break;
      case 270:
#line 882 "parse.y"
{ yygotominor.yy328 = TK_AFTER;  }
#line 2983 "parse.c"
        break;
      case 271:
#line 883 "parse.y"
{ yygotominor.yy328 = TK_INSTEAD;}
#line 2988 "parse.c"
        break;
      case 273:
      case 274:
      case 275:
#line 888 "parse.y"
{yygotominor.yy378.a = yymsp[0].major; yygotominor.yy378.b = 0;}
#line 2995 "parse.c"
        break;
      case 276:
#line 891 "parse.y"
{yygotominor.yy378.a = TK_UPDATE; yygotominor.yy378.b = yymsp[0].minor.yy232;}
#line 3000 "parse.c"
        break;
      case 277:
      case 278:
#line 894 "parse.y"
{ yygotominor.yy328 = TK_ROW; }
#line 3006 "parse.c"
        break;
      case 279:
#line 896 "parse.y"
{ yygotominor.yy328 = TK_STATEMENT; }
#line 3011 "parse.c"
        break;
      case 280:
#line 899 "parse.y"
{ yygotominor.yy418 = 0; }
#line 3016 "parse.c"
        break;
      case 281:
#line 900 "parse.y"
{ yygotominor.yy418 = yymsp[0].minor.yy418; }
#line 3021 "parse.c"
        break;
      case 282:
#line 904 "parse.y"
{
  yymsp[-2].minor.yy451->pNext = yymsp[0].minor.yy451;
  yygotominor.yy451 = yymsp[-2].minor.yy451;
}
#line 3029 "parse.c"
        break;
      case 283:
#line 908 "parse.y"
{ yygotominor.yy451 = 0; }
#line 3034 "parse.c"
        break;
      case 284:
#line 914 "parse.y"
{ yygotominor.yy451 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy430, yymsp[-1].minor.yy322, yymsp[0].minor.yy418, yymsp[-4].minor.yy328); }
#line 3039 "parse.c"
        break;
      case 285:
#line 919 "parse.y"
{yygotominor.yy451 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy430, yymsp[-4].minor.yy232, yymsp[-1].minor.yy322, 0, yymsp[-7].minor.yy328);}
#line 3044 "parse.c"
        break;
      case 286:
#line 922 "parse.y"
{yygotominor.yy451 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy430, yymsp[-1].minor.yy232, 0, yymsp[0].minor.yy91, yymsp[-4].minor.yy328);}
#line 3049 "parse.c"
        break;
      case 287:
#line 926 "parse.y"
{yygotominor.yy451 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy430, yymsp[0].minor.yy418);}
#line 3054 "parse.c"
        break;
      case 288:
#line 929 "parse.y"
{yygotominor.yy451 = sqlite3TriggerSelectStep(yymsp[0].minor.yy91); }
#line 3059 "parse.c"
        break;
      case 289:
#line 932 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy418->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy418, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3068 "parse.c"
        break;
      case 290:
#line 937 "parse.y"
{
  yygotominor.yy418 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy430); 
  yygotominor.yy418->iColumn = yymsp[-3].minor.yy328;
  sqlite3ExprSpan(yygotominor.yy418, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3077 "parse.c"
        break;
      case 291:
#line 945 "parse.y"
{yygotominor.yy328 = OE_Rollback;}
#line 3082 "parse.c"
        break;
      case 293:
#line 947 "parse.y"
{yygotominor.yy328 = OE_Fail;}
#line 3087 "parse.c"
        break;
      case 294:
#line 952 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy439);
}
#line 3094 "parse.c"
        break;
      case 295:
#line 958 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy430, &yymsp[-1].minor.yy430, yymsp[0].minor.yy92.type, &yymsp[0].minor.yy92.key);
}
#line 3101 "parse.c"
        break;
      case 296:
#line 962 "parse.y"
{ yygotominor.yy92.type = 0; }
#line 3106 "parse.c"
        break;
      case 297:
#line 963 "parse.y"
{ yygotominor.yy92.type=1; yygotominor.yy92.key = yymsp[0].minor.yy430; }
#line 3111 "parse.c"
        break;
      case 298:
#line 964 "parse.y"
{ yygotominor.yy92.type=2; yygotominor.yy92.key = yymsp[0].minor.yy0; }
#line 3116 "parse.c"
        break;
      case 301:
#line 970 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy430);
}
#line 3123 "parse.c"
        break;
      case 302:
#line 976 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3128 "parse.c"
        break;
      case 303:
#line 977 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy430, &yymsp[0].minor.yy430);}
#line 3133 "parse.c"
        break;
      case 304:
#line 982 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy439,&yymsp[0].minor.yy430);
}
#line 3140 "parse.c"
        break;
      case 305:
#line 985 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy430);
}
#line 3147 "parse.c"
        break;
      case 306:
#line 988 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy439);
}
#line 3154 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3221 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
