#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""Exception classes"""
# Copyright (C) 2008-2009 Sebastian Heinlein <devel@glatzor.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

__author__  = "Sebastian Heinlein <devel@glatzor.de>"

import dbus

class APTDError(dbus.DBusException):
    """Internal error of the aptdaemon"""
    _dbus_error_name = "org.debian.apt"

class TransactionRoleAlreadySet(APTDError):
    """Error if a transaction has already been configured."""
    _dbus_error_name = "org.debian.apt.TransactionRoleAlreadySet"

class TransactionAlreadyRunning(APTDError):
    """Error if a transaction has already been configured."""
    _dbus_error_name = "org.debian.apt.TransactionAlreadyRunning"

class ForeignTransaction(APTDError):
    """Error if a transaction was initialized by a different user."""
    _dbus_error_name = "org.debian.apt.TransactionAlreadyRunning"

class TransactionFailed(APTDError):
    """Internal error if a transaction could not be processed successfully."""
    _dbus_error_name = "org.debian.apt.TransactionFailed"
    def __init__(self, enum, msg=""):
        APTDError.__init__(self)
        self.enum = enum
        self.message = msg

class TransactionCancelled(APTDError):
    """Internal error if a transaction was cancelled."""
    _dbus_error_name = "org.debian.apt.TransactionCancelled"

class NotAuthorizedError(APTDError):
    """Missing authorization for a given method"""
    _dbus_error_name = "org.debian.apt.NotAuthorized"
    def __init__(self, action, sender):
        APTDError.__init__(self, "NotAuthorizedError: %s %s" % (action, sender))
        self.sender = sender
        self.action = action

class RepositoryInvalidError(APTDError):
    """The added repository is invalid"""
    _dbus_error_name = "org.debian.apt.RepositoryInvalid"

# vim:ts=4:sw=4:et
