// cmdline-prompt.h                     -*-c++-*-
//
//  Copyright 2004 Daniel Burrows

#ifndef CMDLINE_PROMPT_H
#define CMDLINE_PROMPT_H

#include "cmdline_common.h"

/** The main preview-prompt-adjust-preview loop for the command-line
 *  interface.  Displays a preview of what will happen, then allows
 *  the user to confirm, cancel, or perform a number of other actions.
 *  to_install and friends are meant to be the sets the user
 *  explicitly selected (so the prompt can be displayed only when
 *  extra stuff is added or removed).
 *
 *  \param as_upgrade currently ignored; meant to control how the
 *                    preview and prompting are handled.
 *  \param to_install a set of packages to install.
 *  \param to_hold a set of packages to hold.
 *  \param to_remove a set of packages to remove.
 *  \param to_purge a set of packages to purge.
 *  \param showvers \b true to show version information in the preview.
 *  \param showdeps \b true to show dependency information in the preview.
 *  \param showsize \b true to show size information in the preview.
 *  \param verbose the current verbosity level
 *  \param assume_yes if \b true, assume the user entered "yes"
 *                    at the prompt.
 */
bool cmdline_do_prompt(bool as_upgrade,
		       pkgset &to_install,
		       pkgset &to_hold,
		       pkgset &to_remove,
		       pkgset &to_purge,
		       bool showvers,
		       bool showdeps,
		       bool showsize,
		       bool always_prompt,
		       int verbose,
		       bool assume_yes);

#endif // CMDLINE_PROMPT_H
