/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jason Smith <jason.smith@canonical.com>
 *
 */

#include "bamf-legacy-window-test.h"
#include "bamf-legacy-screen-private.h"

G_DEFINE_TYPE (BamfLegacyWindowTest, bamf_legacy_window_test, BAMF_TYPE_LEGACY_WINDOW);

gint
bamf_legacy_window_test_get_pid (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return  self->pid;
}

guint32
bamf_legacy_window_test_get_xid (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->xid;
}

void
bamf_legacy_window_test_set_attention (BamfLegacyWindowTest *self, gboolean val)
{
  if (self->needs_attention == val)
    return;

  self->needs_attention = val;

  g_signal_emit_by_name (self, "state-changed");
}

gboolean
bamf_legacy_window_test_needs_attention (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->needs_attention;
}

void
bamf_legacy_window_test_set_active (BamfLegacyWindowTest *self, gboolean val)
{
  if (self->is_active == val)
    return;

  self->is_active = val;

  g_signal_emit_by_name (self, "state-changed");
}

gboolean
bamf_legacy_window_test_is_active (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->is_active;
}

void
bamf_legacy_window_test_set_desktop (BamfLegacyWindowTest *self, gboolean val)
{
  if (self->is_desktop == val)
    return;

  self->is_desktop = val;

  g_signal_emit_by_name (self, "state-changed");
}

gboolean
bamf_legacy_window_test_is_desktop (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->is_desktop;
}

void
bamf_legacy_window_test_set_skip (BamfLegacyWindowTest *self, gboolean val)
{
  if (self->is_skip == val)
    return;

  self->is_skip = val;

  g_signal_emit_by_name (self, "state-changed");
}

gboolean
bamf_legacy_window_test_is_skip_tasklist (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->is_skip;
}

void
bamf_legacy_window_test_set_name (BamfLegacyWindowTest *self, char *val)
{
  if (g_strcmp0 (self->name, val) == 0)
    return;

  self->name = val;

  g_signal_emit_by_name (self, "name-changed");
}

static const char *
bamf_legacy_window_test_get_name (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return  self->name;
}

static const char *
bamf_legacy_window_test_get_class_name (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return  self->wm_class_name;
}

static const char *
bamf_legacy_window_test_get_class_instance_name (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return  self->wm_class_instance;
}

char *
bamf_legacy_window_test_get_exec_string (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->exec;
}

char *
bamf_legacy_window_test_get_app_id (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;
  g_return_val_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (legacy_window), NULL);

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->application_id;
}

char *
bamf_legacy_window_test_get_unique_bus_name (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;
  g_return_val_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (legacy_window), NULL);

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->unique_bus_name;
}

char *
bamf_legacy_window_test_get_menu_object_path (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;
  g_return_val_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (legacy_window), NULL);

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->dbus_menu_object_path;
}

void
bamf_legacy_window_test_get_geometry (BamfLegacyWindow *legacy_window,
                                      gint *x, gint *y,
                                      gint *width, gint *height)
{
  BamfLegacyWindowTest *self;
  g_return_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (legacy_window));

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  *x = self->geometry.x;
  *y = self->geometry.y;
  *width = self->geometry.width;
  *height = self->geometry.height;
}

BamfWindowMaximizationType
bamf_legacy_window_test_maximized (BamfLegacyWindow *legacy_window)
{
  BamfLegacyWindowTest *self;
  g_return_val_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (legacy_window), BAMF_WINDOW_FLOATING);

  self = BAMF_LEGACY_WINDOW_TEST (legacy_window);

  return self->maximized;
}

void
bamf_legacy_window_test_close (BamfLegacyWindowTest *self)
{
  self->is_closed = TRUE;
  g_signal_emit_by_name (self, "closed");
}

void
bamf_legacy_window_test_set_geometry (BamfLegacyWindowTest *self, int x, int y,
                                 int width, int height)
{
  g_return_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (self));

  self->geometry.x = x;
  self->geometry.y = y;
  self->geometry.width = width;
  self->geometry.height = height;
  g_signal_emit_by_name (self, BAMF_LEGACY_WINDOW_SIGNAL_GEOMETRY_CHANGED);
}

void
bamf_legacy_window_test_set_maximized (BamfLegacyWindowTest *self,
                                  BamfWindowMaximizationType maximized)
{
  g_return_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (self));

  self->maximized = maximized;
  g_signal_emit_by_name (self, BAMF_LEGACY_WINDOW_SIGNAL_GEOMETRY_CHANGED);
  g_signal_emit_by_name (self, BAMF_LEGACY_WINDOW_SIGNAL_STATE_CHANGED);
}

void
bamf_legacy_window_test_set_application_id (BamfLegacyWindowTest *self, const char *id)
{
  g_return_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (self));

  self->application_id = g_strdup (id);
}

void
bamf_legacy_window_test_set_unique_bus_name (BamfLegacyWindowTest *self, const char *bus_name)
{
  g_return_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (self));

  self->unique_bus_name = g_strdup (bus_name);
}

void
bamf_legacy_window_test_set_dbus_menu_object_path (BamfLegacyWindowTest *self, const char *object_path)
{
  g_return_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (self));

  self->dbus_menu_object_path = g_strdup (object_path);
}

gboolean
bamf_legacy_window_test_is_closed (BamfLegacyWindow *window)
{
  g_return_val_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (window), TRUE);

  BamfLegacyWindowTest *self = BAMF_LEGACY_WINDOW_TEST (window);
  return self->is_closed;
}

static void
handle_destroy_notify (BamfLegacyWindowTest *copy, BamfLegacyWindowTest *self_was_here)
{
  BamfLegacyScreen *screen = bamf_legacy_screen_get_default ();
  _bamf_legacy_screen_open_test_window (screen, copy);
}

void
bamf_legacy_window_test_reopen (BamfLegacyWindow *window)
{
  g_return_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (window));

  BamfLegacyWindowTest *self = BAMF_LEGACY_WINDOW_TEST (window);
  BamfLegacyWindowTest *copy = bamf_legacy_window_copy (self);
  g_object_weak_ref (G_OBJECT (self), (GWeakNotify) handle_destroy_notify, copy);
  bamf_legacy_window_test_close (self);
}

BamfWindowType
bamf_legacy_window_test_get_window_type (BamfLegacyWindow *window)
{
  g_return_val_if_fail (BAMF_IS_LEGACY_WINDOW_TEST (window), TRUE);

  BamfLegacyWindowTest *self = BAMF_LEGACY_WINDOW_TEST (window);
  return self->window_type;
}

void
bamf_legacy_window_test_dispose (GObject *object)
{
  G_OBJECT_CLASS (bamf_legacy_window_test_parent_class)->dispose (object);
}

void
bamf_legacy_window_test_class_init (BamfLegacyWindowTestClass *klass)
{
  BamfLegacyWindowClass *win_class = BAMF_LEGACY_WINDOW_CLASS (klass);
  GObjectClass *obj_class = G_OBJECT_CLASS (klass);

  obj_class->dispose          = bamf_legacy_window_test_dispose;
  win_class->get_name         = bamf_legacy_window_test_get_name;
  win_class->get_class_name   = bamf_legacy_window_test_get_class_name;
  win_class->get_class_instance_name = bamf_legacy_window_test_get_class_instance_name;
  win_class->get_exec_string  = bamf_legacy_window_test_get_exec_string;
  win_class->get_xid          = bamf_legacy_window_test_get_xid;
  win_class->get_pid          = bamf_legacy_window_test_get_pid;
  win_class->needs_attention  = bamf_legacy_window_test_needs_attention;
  win_class->is_skip_tasklist = bamf_legacy_window_test_is_skip_tasklist;
  win_class->is_desktop       = bamf_legacy_window_test_is_desktop;
  win_class->is_active        = bamf_legacy_window_test_is_active;
  win_class->get_app_id       = bamf_legacy_window_test_get_app_id;
  win_class->get_unique_bus_name = bamf_legacy_window_test_get_unique_bus_name;
  win_class->get_menu_object_path = bamf_legacy_window_test_get_menu_object_path;
  win_class->get_geometry     = bamf_legacy_window_test_get_geometry;
  win_class->get_window_type  = bamf_legacy_window_test_get_window_type;
  win_class->maximized        = bamf_legacy_window_test_maximized;
  win_class->is_closed        = bamf_legacy_window_test_is_closed;
  win_class->reopen           = bamf_legacy_window_test_reopen;
}


void
bamf_legacy_window_test_init (BamfLegacyWindowTest *self)
{
  self->pid = g_random_int_range (1, 100000);
  self->maximized = BAMF_WINDOW_FLOATING;
  self->is_closed = FALSE;
}


BamfLegacyWindowTest *
bamf_legacy_window_copy (BamfLegacyWindowTest *self)
{
  BamfLegacyWindowTest *copy;

  copy = g_object_new (BAMF_TYPE_LEGACY_WINDOW_TEST, NULL);
  copy->xid = self->xid;
  copy->pid = self->pid;
  copy->name = g_strdup (self->name);
  copy->wm_class_name = g_strdup (self->wm_class_name);
  copy->wm_class_instance = g_strdup (self->wm_class_instance);
  copy->exec = g_strdup (self->exec);
  copy->application_id = g_strdup (self->application_id);
  copy->unique_bus_name = g_strdup (self->unique_bus_name);
  copy->dbus_menu_object_path = g_strdup (self->dbus_menu_object_path);
  copy->needs_attention = self->needs_attention;
  copy->is_desktop = self->is_desktop;
  copy->is_skip = self->is_skip;
  copy->is_active = self->is_active;
  copy->is_closed = self->is_closed;
  copy->geometry = self->geometry;
  copy->maximized = self->maximized;
  copy->window_type = self->window_type;

  return copy;
}

BamfLegacyWindowTest *
bamf_legacy_window_test_new (guint32 xid, gchar *name, gchar *wmclass_name, gchar *exec)
{
  BamfLegacyWindowTest *self;

  self = g_object_new (BAMF_TYPE_LEGACY_WINDOW_TEST, NULL);
  self->window_type = BAMF_WINDOW_NORMAL;
  self->xid = xid;
  self->name = g_strdup (name);
  self->wm_class_name = g_strdup (wmclass_name);
  self->exec = g_strdup (exec);

  return self;
}
