/* unit-sha1.c: 
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 * Modified for SHA1:
 *  Copyright (C) 2004 Colin Walters <walters@verbum.org>
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */



#include "hackerlab/hash/sha1.h"
#include "hackerlab/cmd/main.h"



static t_uchar * program_name = "unit-hash-sha1";
static t_uchar * usage = "[options]";
static t_uchar * version_string = "1.0";

#define OPTS(OP, OP2) \
  OP (opt_help_msg, "h", "help", 0, \
      "Display a help message and exit.") \
  OP (opt_version, "V", "version", 0, \
      "Display a release identifier string") \
  OP2 (opt_version, 0, 0, 0, "and exit.")

enum options
{
  OPTS (OPT_ENUM, OPT_IGN)  
};

struct opt_desc opts[] = 
{
  OPTS (OPT_DESC, OPT_DESC)
    {-1, 0, 0, 0, 0}
};



int
main (int argc, char * argv[])
{
  int o;
  struct opt_parsed * option;

  option = 0;

  while (1)
    {
      o = opt_standard (lim_use_must_malloc, &option, opts, &argc, argv, program_name, usage, version_string, 0, opt_help_msg, opt_none, opt_version);
      if (o == opt_none)
	break;
      switch (o)
	{
	default:
	  safe_printfmt (2, "unhandled option `%s'\n", option->opt_string);
	  panic ("internal error parsing arguments");
	}
    }

  {
    struct test_case
      {
        char * string;
        t_uchar answer[20];
      };

    struct test_case tests[] = 
      {
        {"", { 0xDA, 0x39, 0xA3, 0xEE, 0x5E, 0x6B, 0x4B, 0x0D, 0x32, 0x55, 0xBF, 0xEF, 0x95, 0x60, 0x18, 0x90, 0xAF, 0xD8, 0x07, 0x09 }},
        {"a", { 0x86, 0xF7, 0xE4, 0x37, 0xFA, 0xA5, 0xA7, 0xFC, 0xE1, 0x5D, 0x1D, 0xDC, 0xB9, 0xEA, 0xEA, 0xEA, 0x37, 0x76, 0x67, 0xB8 }},
        {"abc", { 0xA9, 0x99, 0x3E, 0x36, 0x47, 0x06, 0x81, 0x6A, 0xBA, 0x3E, 0x25, 0x71, 0x78, 0x50, 0xC2, 0x6C, 0x9C, 0xD0, 0xD8, 0x9D }},
        {"message digest", { 0xC1, 0x22, 0x52, 0xCE, 0xDA, 0x8B, 0xE8, 0x99, 0x4D, 0x5F, 0xA0, 0x29, 0x0A, 0x47, 0x23, 0x1C, 0x1D, 0x16, 0xAA, 0xE3 }},
        {"Lo, this message is exactly 64 bytes long, no more and not less.",
           { 0x6B, 0xE5, 0x86, 0x57, 0x77, 0xFD, 0x7F, 0x61, 0x3C, 0xD8, 0xFA, 0xEE, 0xE2, 0x3D, 0x09, 0x91, 0xB4, 0xF0, 0x8B, 0x1E }},
        {"This message has 56 bytes which is an interesting amount",
           { 0x86, 0xCB, 0x0C, 0x89, 0x74, 0xE7, 0xEF, 0x62, 0x6F, 0x86, 0x25, 0x56, 0x2C, 0x3F, 0x48, 0xE4, 0x60, 0x48, 0x1D, 0x59 }},
        {"This message has 57 bytes which is an interesting amount!",
	 { 0xCF, 0xB6, 0x84, 0xE3, 0x7F, 0x0C, 0xDC, 0xA5, 0x5E, 0x5A, 0x9D, 0x3E, 0x8C, 0x53, 0x99, 0xDC, 0x34, 0xAE, 0xAB, 0x86 }},
        {"This message has 58 bytes which is an interesting amount!!",
           { 0x5A, 0x08, 0xE6, 0x84, 0xA9, 0xD4, 0xDD, 0x1B, 0x46, 0xEF, 0x40, 0x00, 0xEE, 0xDD, 0x98, 0x9A, 0xFD, 0x9A, 0x0C, 0x87 }},
        {("This message has rather more than 64 bytes\n"
          "which means that it will take more than SHA1 buffer\n"
          "to process.  I think that that's an interesting case\n"
          "to test for, don't you?   I could try to come up with\n"
          "more edge cases but I think this will be the last one\n"
          "for now.\n"),
           { 0xF0, 0xFC, 0xAE, 0xD7, 0x34, 0xB9, 0x0B, 0x41, 0x89, 0xA2, 0x1B, 0xBC, 0xA7, 0x6B, 0x83, 0x15, 0x7F, 0x32, 0x51, 0x48 }},
        {0, }
      };

    sha1_context_t context_a;
    int x;

    context_a = make_sha1_context (0);

    for (x = 0; tests[x].string; ++x)
      {
        sha1_context_t context_b = 0;
        t_uchar digest_a[20];
        t_uchar digest_b[20];
        int y;

        context_b = make_sha1_context (0);

        sha1_scan (context_a, tests[x].string, str_length (tests[x].string));
        sha1_scan (context_b, tests[x].string, str_length (tests[x].string));
        sha1_final (digest_a, context_a);
        sha1_final (digest_b, context_b);

        for (y = 0; y < 20; ++y)
          {
            invariant (digest_a[y] == digest_b[y]);
            invariant (digest_a[y] == tests[x].answer[y]);
          }

        free_sha1_context (0, context_b);
      }

    free_sha1_context (0, context_a);
  }

  return 0;
}




/* tag: Colin Walters Mon, 05 Jan 2004 18:22:29 -0500 (unit-sha1.c)
 */

