#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test getting working trees
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "baz export"

begin_test "export a whole revision"
tla export jane@example.com--2003/hello-world--mainline--1.0
test -d hello-world--mainline--1.0--base-0
test -f hello-world--mainline--1.0--base-0/README
test -f hello-world--mainline--1.0--base-0/hello-world.c
test ! -e hello-world--mainline--1.0--base-0/{arch}
end_test 

begin_test "export a dir from a revision"
set -x
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
mkdir X
mkdir X/Y
touch X/Y/foo
tla add X
tla add X/Y
tla add X/Y/foo
tla commit -s"add X and X/Y and X/Y/foo."
cd ..
tla export jane@example.com--2003/hello-world--mainline--1.0/X/Y bar
test -d bar
test ! -f bar/README
test ! -f bar/hello-world.c
test ! -e bar/{arch}
test -d bar/X
test -d bar/X/Y
test -f bar/X/Y/foo
end_test 

begin_test "export a nested dir from a revision"
set -x
tla export jane@example.com--2003/hello-world--mainline--1.0/X bar
test -d bar
test ! -f bar/README
test ! -f bar/hello-world.c
test ! -e bar/{arch}
test -d bar/X
test -d bar/X/Y
test -f bar/X/Y/foo
end_test 

clean_workdir
