# brltty.spec.  Generated from brltty.spec.in by configure.
###############################################################################
# BRLTTY - A background process providing access to the console screen (when in
#          text mode) for a blind person using a refreshable braille display.
#
# Copyright (C) 1995-2014 by The BRLTTY Developers.
#
# BRLTTY comes with ABSOLUTELY NO WARRANTY.
#
# This is free software, placed under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any
# later version. Please see the file LICENSE-GPL for details.
#
# Web Page: http://mielke.cc/brltty/
#
# This software is maintained by Dave Mielke <dave@mielke.cc>.
###############################################################################

Name: brltty
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

Vendor: The BRLTTY Developers
Packager: Dave Mielke <dave@mielke.cc>
URL: http://brltty.com
Source: http://brltty.com/archive/%{name}-%{version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc
%define _systemddir /usr/lib/systemd/system

Requires: libicu

BuildRequires: /bin/sh
BuildRequires: /usr/bin/env
BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: coreutils
BuildRequires: binutils
BuildRequires: /usr/bin/awk
BuildRequires: glibc-devel
BuildRequires: tcl
BuildRequires: libicu-devel
BuildRequires: ncurses-devel
BuildRequires: linuxdoc-tools
BuildRequires: doxygen
BuildRequires: bluez-libs-devel
BuildRequires: alsa-lib-devel

AutoProv: no
Provides: brlapi-server
AutoReq: yes

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.


%package -n brltty-braille-brlapi
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

AutoProv: no
AutoReq: yes

Summary: BrlAPI braille driver for BRLTTY.
%description -n brltty-braille-brlapi
This package provides the BrlAPI braille driver for BRLTTY.

Install this package if you need to communicate with
another instance of BRLTTY which is actually in control
of the braille device.


%package -n brltty-braille-xwindow
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXt-devel
BuildRequires: neXtaw-devel

AutoProv: no
AutoReq: yes

Summary: XWindow braille driver for BRLTTY.
%description -n brltty-braille-xwindow
This package provides the XWindow braille driver for BRLTTY.
This driver presents a virtual braille device within a graphical
user interface. It is primarily intended for sighted developers
who don't have access to a real braille device but still wish to
assess the accessibility of their applications.

Install this package if you would like to see how usable an
application would be by a blind person using a braille device.


%package -n brltty-speech-espeak
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: espeak

BuildRequires: espeak-devel

AutoProv: no
AutoReq: yes
Requires: espeak

Summary: eSpeak speech driver for BRLTTY.
%description -n brltty-speech-espeak
This package provides the eSpeak speech driver for BRLTTY.

Install this package if you would like to be able to use the
eSpeak text-to-speech engine.


%package -n brltty-speech-festival
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: festival

AutoProv: no
AutoReq: yes
Requires: festival

Summary: Festival speech driver for BRLTTY.
%description -n brltty-speech-festival
This package provides the Festival speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival text-to-speech engine.


%package -n brltty-speech-flite
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: flite

BuildRequires: flite-devel

AutoProv: no
AutoReq: yes
Requires: flite

Summary: Festival Lite speech driver for BRLTTY.
%description -n brltty-speech-flite
This package provides the Festival Lite speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival Lite text-to-speech engine.


%package -n brltty-speech-speechd
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: speech-dispatcher

BuildRequires: speech-dispatcher-devel

AutoProv: no
AutoReq: yes
Requires: speech-dispatcher

Summary: Speech Dispatcher speech driver for BRLTTY.
%description -n brltty-speech-speechd
This package provides the Speech Dispatcher speech driver for BRLTTY.

Install this package if you would like to be able to use the
Speech Dispatcher text-to-speech server.


%package -n brltty-screen-atspi
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: at-spi

BuildRequires: at-spi-devel

AutoProv: no
AutoReq: yes
Requires: at-spi

Summary: AT-SPI screen driver for BRLTTY.
%description -n brltty-screen-atspi
This package provides the AT-SPI screen driver for BRLTTY.

Install this package if you would like to be able to
access GTK-based applications via the Assistive
Technology Service Provider Interface.


%package -n brltty-screen-atspi2
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: dbus

BuildRequires: at-spi2-core-devel

AutoProv: no
AutoReq: yes
Requires: dbus

Summary: AT-SPI2 screen driver for BRLTTY.
%description -n brltty-screen-atspi2
This package provides the AT-SPI2 screen driver for BRLTTY.

Install this package if you would like to be able to
access graphical applications via the D-Bus port of
the Assistive Technology Service Provider Interface.


%package -n brltty-screen-screen
Version: 5.2dev
Release: 1
Group: System Environment/Daemons
License: GPL

AutoProv: no
AutoReq: yes
Requires: screen

Summary: Screen screen driver for BRLTTY.
%description -n brltty-screen-screen
This package provides the Screen screen driver for BRLTTY.

Install this package if you would like to be able to
directly access session windows maintained by the
screen program.


%package -n brltty-utils
Version: 5.2dev
Release: 1
Group: Development/Tools
License: GPL

BuildRequires: ncurses-devel

AutoProv: no
AutoReq: yes

Summary: Commands for maintaining BRLTTY data files.
%description -n brltty-utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%package -n brltty-devel
Version: 5.2dev
Release: 1
Group: Development/Tools
License: GPL

AutoProv: no
AutoReq: yes

Summary: Headers for BRLTTY.
%description -n brltty-devel
This package provides many of the header files for BRLTTY's core, as well as
header files which define the packets and keys for several braille devices.

Install this package if you're developing or maintaining an application which
needs to (or wishes to) use functionality provided by BRLTTY's core, which
needs to interpret and/or create raw braille device packets, or which needs to
interpret key codes as delivered by BrlAPI's raw mode.


%package -n brlapi
Version: 0.6.2
Release: 1
Group: System Environment/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.


%package -n brlapi-devel
Version: 0.6.2
Release: 1
Group: Development/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.


%package -n brlapi-java
Version: 0.6.2
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: gcc-java

AutoProv: no
AutoReq: yes

Summary: Java bindings for BrlAPI.
%description -n brlapi-java
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.


%package -n brlapi-ocaml
Version: 0.6.2
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: ocaml
BuildRequires: ocaml-findlib

AutoProv: no
AutoReq: yes

Summary: OCaml bindings for BrlAPI.
%description -n brlapi-ocaml
This package provides the OCaml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have an OCaml application
which directly accesses a refreshable braille display.


%package -n brlapi-python
Version: 0.6.2
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: python
BuildRequires: python-devel
BuildRequires: Cython

AutoProv: no
AutoReq: yes

Summary: Python bindings for BrlAPI.
%description -n brlapi-python
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.


%package -n brlapi-tcl
Version: 0.6.2
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: tcl
BuildRequires: tcl-devel

AutoProv: no
AutoReq: yes

Summary: Tcl bindings for BrlAPI.
%description -n brlapi-tcl
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.


%package -n brlapi-utils
Version: 0.6.2
Release: 1
Group: Applications/System
License: LGPL

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXtst-devel

AutoProv: no
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi-utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%prep
# %setup -n %{name}-%{version}
%setup -n brltty-5.2dev

%build
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --with-braille-driver=-tt,-vr
make

%install
make install install-documents install-messages
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"
install -d "${RPM_BUILD_ROOT}%{_systemddir}"
install -m 644 Autostart/Systemd/brltty.service "${RPM_BUILD_ROOT}%{_systemddir}/brltty.service"
%find_lang %{name}

%clean
rm -fr "${RPM_BUILD_ROOT}"


%files -f %{name}.lang
%defattr(-,root,root)
%{_bindir}/brltty
%{_libdir}/brltty
%exclude %{_libdir}/brltty/libbrlttybba.so
%exclude %{_libdir}/brltty/libbrlttybxw.so
%exclude %{_libdir}/brltty/libbrlttyses.so
%exclude %{_libdir}/brltty/libbrlttysfl.so
%exclude %{_libdir}/brltty/libbrlttysfv.so
%exclude %{_libdir}/brltty/libbrlttyssd.so
%exclude %{_libdir}/brltty/libbrlttyxas.so
%exclude %{_libdir}/brltty/libbrlttyxa2.so
%exclude %{_libdir}/brltty/libbrlttyxsc.so
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/brltty.1.gz
%doc %{_docdir}/*/LICENSE*
%doc %{_docdir}/*/README*
%doc %{_docdir}/*/ChangeLog
%doc %{_docdir}/*/CONTRIBUTORS
%doc %{_docdir}/*/TODO
%doc %{_docdir}/*/brltty.conf
%doc %{_docdir}/*/KeyTables
%doc %{_docdir}/*/Manual-BRLTTY
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf
%{_systemddir}/brltty.service

%files -n brltty-braille-brlapi
%{_libdir}/brltty/libbrlttybba.so

%files -n brltty-braille-xwindow
%{_libdir}/brltty/libbrlttybxw.so

%files -n brltty-speech-espeak
%{_libdir}/brltty/libbrlttyses.so

%files -n brltty-speech-festival
%{_libdir}/brltty/libbrlttysfv.so

%files -n brltty-speech-flite
%{_libdir}/brltty/libbrlttysfl.so

%files -n brltty-speech-speechd
%{_libdir}/brltty/libbrlttyssd.so

%files -n brltty-screen-atspi
%{_libdir}/brltty/libbrlttyxas.so

%files -n brltty-screen-atspi2
%{_libdir}/brltty/libbrlttyxa2.so

%files -n brltty-screen-screen
%{_libdir}/brltty/libbrlttyxsc.so

%files -n brltty-utils
%{_bindir}/brltty-*

%files -n brltty-devel
%{_includedir}/brltty

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%doc %{_docdir}/*/Manual-BrlAPI

%files -n brlapi-java
/usr/share/java/*
/usr/lib/jni/*

%files -n brlapi-ocaml
/usr/lib/ocaml/brlapi

%files -n brlapi-python
/usr/lib/python2.7/dist-packages/[bB]rlapi[-.]*

%files -n brlapi-tcl
/usr/local/lib/tcltk/brlapi-0.6.2/libbrlapi_tcl.so
/usr/local/lib/tcltk/brlapi-0.6.2/pkgIndex.tcl

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%doc %{_mandir}/man3/*
%doc %{_docdir}/*/BrlAPIref

%files -n brlapi-utils
%{_bindir}/xbrlapi
%{_bindir}/eutp
%{_bindir}/vstp
%doc %{_mandir}/man1/xbrlapi.1.gz
%doc %{_mandir}/man1/eutp.1.gz
%doc %{_mandir}/man1/vstp.1.gz
/usr/share/gdm/greeter/autostart/xbrlapi.desktop


%changelog
* Thu Mar 27 2014 Dave Mielke <dave@mielke.cc> 5.1
+  General Changes:
      An alert (2 beeps every 30 seconds) is now played when the screen is frozen.
      Saving the preferences file now adds comments showing the possible values
      (and the default value) for each property.
      USB device identifiers now support the genericDevices= (yes, no) parameter.
+  Command Changes:
      Unicode braille dots input is now supported:
         The BRLUCDOTS toggle command has been added.
         The "Braille Input Mode" preference has been added to "Input Options".
      Skip Blank Windows now works like Skip Identical Lines:
         FWINLT/FWINRT are unchanged:
            If SBW is off then don't skip blank windows.
            If SBW is on then honour Skip Blank Windows Mode.
         FWINLTSKIP/FWINRTSKIP now work as follows:
            If SBW is off then honour Skip Blank Windows Mode.
            If SBW is on then don't skip blank windows.
+  The FreedomScientific Braille Driver:
      Various problems with detecting a connection error have been resolved.
      A problem causing a braille display freeze has been resolved.
+  The Papenmeier Braille Driver:
      The following bindings have been added for models with 22 status cells:
         Binding        Command
         Status20       BRLUCDOTS
         Dot7+Status20  BRLUCDOTS+off
         Dot8+Status20  BRLUCDOTS+on
+  The Application Programming Interface (BrlAPI):
      The version has been increased to 0.6.2 (from 0.6.1).
      The retainDots= parameter has been removed.
      The PASSDOTS command is no longer implicitly accepted by default.
      Explicitly accepting PASSDOTS bypasses the conversion to PASSCHAR.
+  Environment Variables:
      BRLTTY_NO_API (yes, no) is now supported.
+  The Configuration File (brltty.conf):
      no-api (yes, no) can now be specified.
      The following directives have been added:
         include <file>
         ifSet <property> [<statement>]
         ifNotSet <property> [<statement>]
         assign <variable> <value>
         ifVar <variable> [<statement>]
         ifNotVar <variable> [<statement>]
         else
         endIf
      The special syntax \{variable} is now supported.
+  Text Tables:
      The Hebrew text table (he) has been modernized.
+  Contraction Tables:
      The US English Grade 2 (en-us-g2) contraction table has been updated.
+  Key Tables:
      The following binding changes have been made to the "keypad" key table:
         Binding           Old      New
         KP0+KPMinus       SIXDOTS  SIXDOTS+off
         KP0+KPPlus        -        SIXDOTS+on
         KPPeriod+KPMinus  FREEZE   BRLUCDOTS+off
         KPPeriod+KPPlus   -        BRLUCDOTS+on
         KPMinus+KP3       -        FREEZE
      The <statement> operand of the ifKey directive is now optional.
      The following directives have been added:
         ifNotKey <key> [<statement>]
         ifVar <variable> [<statement>]
         ifNotVar <variable> [<statement>]
         else
         endIf
+  Data File Customization:
      The XDG configuration file paradigm is now supported.
      A local version of any data file can be placed in "/etc/xdg/brltty/".
      The XDG_CONFIG_HOME and XDG_CONFIG_DIRS environment variables are supported.
      See "README.Customize" for full details.
+  Build Changes:
      The source has been moved from an svn repository to a git repository at:
         "https://github.com/brltty/brltty.git".
      The URL of the web site has been changed to "http://brltty.com".
      Many of the core headers are now installed (in "/usr/include/brltty/").
      The brltty-devel rpm is now created.
      The --with-api-socket-path= configure option has been added.

