#!/bin/sh

set -e

esslist=essential-packages-list
mirror_list="http://archive.ubuntu.com/ubuntu http://ports.ubuntu.com/ubuntu-ports"
#mirror_list="http://yourmirror/ubuntu http://yourmirror/ubuntu-ports $mirror_list"
dist=`lsb_release -cs`

arches=`awk '($1 != "" && $1 !~ /^#/) {print $2}' /usr/share/dpkg/archtable \
	| sort | uniq`

for arch in $arches
do
	if [ ! -f Packages-$arch ]
	then
		for mirror in $mirror_list; do
			if wget -O Packages-$arch.bz2 $mirror/dists/$dist/main/binary-$arch/Packages.bz2
			then
				bunzip2 -f Packages-$arch.bz2
				break
			else
				rm -f Packages-$arch
			fi
		done
	fi
	if [ -f Packages-$arch ]
	then
		printf > $esslist-$arch \
			'This list was generated on %s for %s\n' \
			"`LANG=C date`" "$arch"
		echo >> $esslist-$arch \
			'It contains a list of essential packages' \
			'(which are also build-essential).'
		echo >> $esslist-$arch

		grep-status -FEssential -sPackage -ni yes Packages-$arch \
			| sort >> $esslist-$arch
	else
		echo "No essential packages list is available" \
			"for $arch in $dist" > $esslist-$arch
	fi
done
rm -f Packages-*
