
//  (C) Copyright Edward Diener 2011-2015
//  Use, modification and distribution are subject to the Boost Software License,
//  Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
//  http://www.boost.org/LICENSE_1_0.txt).

#include <boost/vmd/get_type.hpp>
#include <boost/vmd/equal.hpp>
#include <boost/detail/lightweight_test.hpp>

int main()
  {
  
#if BOOST_PP_VARIADICS

  #define BOOST_VMD_REGISTER_ggh (ggh)
  #define BOOST_VMD_DETECT_ggh_ggh
  #define BOOST_VMD_REGISTER_dvd (dvd)
  #define BOOST_VMD_DETECT_dvd_dvd
  
  #define ANIDENTIFIER ggh
  #define ANIDENTIFIER2 dvd
  #define ANUMBER 249
  #define ANUMBER2 17
  #define ASEQ (25)(26)(27)
  #define ATUPLE (0,1,2,3,((a,b))((c,d))((e))((f,g,h)))
  #define ALIST (0,(1,(2,(3,BOOST_PP_NIL))))
  #define ANARRAY (3,(a,b,38))
  #define ATYPE BOOST_VMD_TYPE_IDENTIFIER
  #define ASEQUENCE ANUMBER ALIST ATUPLE ANIDENTIFIER ANARRAY ASEQ
  #define ASEQUENCE2 ANIDENTIFIER2 ASEQ ALIST ANUMBER ATUPLE
  #define ASEQUENCE3 ASEQ ANUMBER2 ATUPLE
  #define ASEQUENCE4
  
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ANIDENTIFIER),BOOST_VMD_TYPE_IDENTIFIER,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ANUMBER),BOOST_VMD_TYPE_NUMBER,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ASEQ),BOOST_VMD_TYPE_SEQ,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ATUPLE),BOOST_VMD_TYPE_TUPLE,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ALIST),BOOST_VMD_TYPE_LIST,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ANARRAY),BOOST_VMD_TYPE_ARRAY,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ATYPE),BOOST_VMD_TYPE_TYPE,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ASEQUENCE),BOOST_VMD_TYPE_SEQUENCE,BOOST_VMD_TYPE_TYPE));
  BOOST_TEST(BOOST_VMD_EQUAL(BOOST_VMD_GET_TYPE(ASEQUENCE4),BOOST_VMD_TYPE_EMPTY,BOOST_VMD_TYPE_TYPE));
  
#else

BOOST_ERROR("No variadic macro support");
  
#endif

  return boost::report_errors();
  
  }
