; easyffi.l -*- Scheme -*-
;
; Copyright (c) 2000-2003, Felix L. Winkelmann
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
; conditions are met:
;
;   Redistributions of source code must retain the above copyright notice, this list of conditions and the following
;     disclaimer. 
;   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
;     disclaimer in the documentation and/or other materials provided with the distribution. 
;   Neither the name of the author nor the names of its contributors may be used to endorse or promote
;     products derived from this software without specific prior written permission. 
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
; CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
; OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.
;
; Send bugs, suggestions and ideas to: 
;
; felix@call-with-current-continuation.org
;
; Felix L. Winkelmann
; Steinweg 1A
; 37130 Gleichen, OT Weissenborn
; Germany


letter [a-zA-Z_]
digit  [0-9.]
space  [ ]

%%

\n 		                   (if pp-mode
				     (begin 
				       (set! pp-mode #f) 'pp-end)
				     (begin
				       (set! pp-mode #f) (yycontinue)) )
{space}+                           (yycontinue)
\9+                                (yycontinue)
\13+                               (yycontinue)
"//"                               (let loop ()
				     (let ([c (yygetc)])
				       (if (or (eq? 'eof c) (char=? #\newline c))
					   (begin
					     (if pp-mode
						 (begin
						   (set! pp-mode #f)
						   'pp-end)
						 (yycontinue) ) )
					   (loop) ) ) )
"/*"                               (let loop ()
				     (let ([c (yygetc)])
				       (cond [(eq? 'eof c) (quit "unexpected end of comment")]
					     [(char=? #\newline c) (loop)]
					     [(char=? c #\*)
					      (if (eq? #\/ (yygetc))
						  (yycontinue)
						  (loop) ) ]
					     [else (loop)] ) ) )
"enum"                             'enum
"typedef"                          'typedef
"extern"                           'extern
"static"                           'static
"__fixnum"                         'fixnum
"__bool"                           'bool
"bool"                             'bool
"__callback"                       'callback
"__declare"                        'declare
"int"                              'int
"unsigned"                         'unsigned
"signed"                           'signed
"float"                            'float
"double"                           'double
"short"                            'short
"long"                             'long
"char"                             'char
"void"                             'void
"struct"                           'struct
"union"                            'union
"const"                            'const
"class"                            'class
"public"                           'public
"protected"                        'protected
"private"                          'private
"volatile"                         'volatile
"virtual"                          'virtual
"explicit"                         'explicit
"inline"                           'inline
"using"                            'using
^#                                 (begin (set! pp-mode #t) (yycontinue))
"define"                           (pp-token 'pp-define)
"include"                          (pp-token 'pp-include)
"ifdef"                            (pp-token 'pp-ifdef)
"ifndef"                           (pp-token 'pp-ifndef)
"elif"                             (pp-token 'pp-elif)
"if"                               (pp-token2 'pp-if 'if)
"pragma"                           (pp-token 'pp-pragma)
"endif"                            (pp-token 'pp-endif)
"else"                             (pp-token2 'pp-else 'else)
"error"                            (pp-token 'pp-error)
"undef"                            (pp-token 'pp-undef)
\"                                 (let loop ([cs '()])
				     (let ([c (yygetc)])
				       (cond [(eq? 'eof c) (quit "unexpected end of string constant")]
					     [(char=? c #\\) (loop (cons (yygetc) cs))]
					     [(char=? c #\")
					      (list 'string (list->string (reverse cs))) ]
					     [else (loop (cons c cs))] ) ) )
\'\\.\'                            (list 'char (string-ref yytext 2))
\'.\'                              (list 'char (string-ref yytext 1))
({letter}|_)({letter}|_|{digit})*  (list 'id yytext)
0(x|X)({digit}|{letter})+          (list 'num (string->number (substring yytext 2 (string-length yytext)) 16))
0{digit}+                          (list 'num (string->number (substring yytext 1 (string-length yytext)) 8))
-?{digit}+                         (list 'num (string->number yytext))
"<"                                (if pp-mode
				       (let loop ([s '()])
					 (let ([c (yygetc)])
					   (cond [(eq? 'eof c) (quit "unexpected end of include file name")]
						 [(char=? #\> c)
						  `(i-string ,(list->string (reverse s))) ]
						 [else (loop (cons c s))] ) ) ) 
				       `(op "<") )
"("                                'open-paren
")"                                'close-paren
"["                                'open-bracket
"]"                                'close-bracket
"{"                                'open-curly
"}"                                'close-curly
","                                'comma
";"                                'semicolon
"*"                                'star
"+="|"-="|">>="|"<<="|"*="|"/="|"%="|"%"|"&="|"|="|"^="|"+"|"-"|"/"|">="|"<="|"=="|"<<"|">>"|"&&"|"||"|"&"|"|"|">"|"<"|"^"|"~"|"?"|"::"|":"|"="
                                     (list 'op yytext)
<<EOF>>                            'stop
<<ERROR>>                          (lexer-error)
