;;;; ctclsh.scm - Extend Tcl with Chicken command


(declare (uses extras srfi-13))


(define error-exn? (condition-predicate 'exn))
(define error-message (condition-property-accessor 'exn 'message))
(define error-arguments (condition-property-accessor 'exn 'arguments))

(define-entry-point 1 
    ((cmd c-string))
    (c-string bool)
  (call-with-current-continuation
   (lambda (return)
     (handle-exceptions ex
	 (return
	  (values
	   (if (error-exn? ex)
	       (string-concatenate
		(cons (error-message ex)
		      (map (lambda (x) (sprintf " ~S" x))
			   (error-arguments ex) ) ) )
	       (->string ex) )
	   #f) )
       (let* ([x (with-input-from-string cmd read)]
	      [r (with-output-to-string (lambda () (write (eval x))))] )
	 (values r #t) ) ) ) ) )
