/* scheme-r4rs.c - Small stub that invokes the Chicken interpreter - felix 
   
   Usage: scheme-r4rs SCRIPTFILENAME ARGUMENT1 ...

   - Runs 'csi' with the given arguments like this:

     csi -quiet -batch SCRIPTFILENAME -no-init -strict -eval "(##sys#script-main 3 9 main)" -- ARGUMENT1 ...
*/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>


#define PREFIX_ARGS        9
#define SCRIPT_ARG         3
#define CMD_PARAMETER      "(##sys#script-main 3 9 main)"


int main(int argc, char *argv[])
{
  char *argsin[] = { "csi", 
		     "-quiet", "-batch",
		     "",
		     "-no-init", "-strict",
		     "-eval", CMD_PARAMETER,
		     "--" },
       **args = (char **)malloc((argc + 10) * sizeof(char *));
  int i;

  if(args == NULL) {
    fprintf(stderr, "%s: out of memory\n", argv[ 0 ]);
    exit(1);
  }

  if(argc < 2) {
    fprintf(stderr, "%s: no script to run\n", argv[ 0 ]);
    exit(1);
  }

  for(i = 0; i < PREFIX_ARGS; ++i)
    args[ i ] = argsin[ i ];

  for(i = 1; i < argc; ++i)
    args[ i + PREFIX_ARGS - 1 ] = argv[ i ];

  args[ SCRIPT_ARG ] = argv[ 1 ];
  args[ argc + PREFIX_ARGS - 1 ] = NULL;
  i = execvp("csi", args);
  fprintf(stderr, "%s: can not execute interpreter: %s\n", argv[ 0 ], strerror(errno));
  exit(1);
}
