/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_EFFECT_CACHE_H_
#define _CTK_EFFECT_CACHE_H_

#include <glib.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <clutk/ctk-effect.h>

G_BEGIN_DECLS

#define CTK_EFFECT_CACHE_MIN_FACTOR            0.0f
#define CTK_EFFECT_CACHE_MAX_FACTOR            1.0f
#define CTK_EFFECT_CACHE_DEFAULT_FACTOR        1.0f

#define CTK_TYPE_EFFECT_CACHE (ctk_effect_cache_get_type ())

#define CTK_EFFECT_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_EFFECT_CACHE, CtkEffectCache))

#define CTK_EFFECT_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_EFFECT_CACHE, CtkEffectCacheClass))

#define CTK_IS_EFFECT_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_EFFECT_CACHE))

#define CTK_IS_EFFECT_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_EFFECT_CACHE))

#define CTK_EFFECT_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_EFFECT_CACHE, CtkEffectCacheClass))

typedef struct _CtkEffectCache        CtkEffectCache;
typedef struct _CtkEffectCacheClass   CtkEffectCacheClass;
typedef struct _CtkEffectCachePrivate CtkEffectCachePrivate;

struct _CtkEffectCache
{
  CtkEffect parent;
  CtkEffectCachePrivate *priv;
};

struct _CtkEffectCacheClass
{
  /*< private >*/
  CtkEffectClass parent_class;
  
  void (*_cache_padding1) (void);
  void (*_cache_padding2) (void);
  void (*_cache_padding3) (void);
  void (*_cache_padding4) (void);
  void (*_cache_padding5) (void);
  void (*_cache_padding6) (void);
};

GType       ctk_effect_cache_get_type (void) G_GNUC_CONST;

CtkEffect * ctk_effect_cache_new      (void);

void ctk_effect_cache_invalidate_texture_cache (CtkEffectCache *self);
void ctk_effect_cache_update_texture_cache (CtkEffectCache *self);

G_END_DECLS

#endif /* _CTK_EFFECT_CACHE_H_ */

