/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Mirco Müller <mirco.mueller@canonical.com>
 *
 */

#ifndef _CTK_EFFECT_DROP_SHADOW_H_
#define _CTK_EFFECT_DROP_SHADOW_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-effect.h>

G_BEGIN_DECLS

#define CTK_EFFECT_DROP_SHADOW_MIN_SIZE           0.1f
#define CTK_EFFECT_DROP_SHADOW_MAX_SIZE           9.0f
#define CTK_EFFECT_DROP_SHADOW_DEFAULT_SIZE       2.0f
#define CTK_EFFECT_DROP_SHADOW_MIN_OFFSET_X     -100
#define CTK_EFFECT_DROP_SHADOW_MAX_OFFSET_X      100
#define CTK_EFFECT_DROP_SHADOW_DEFAULT_OFFSET_X    0
#define CTK_EFFECT_DROP_SHADOW_MIN_OFFSET_Y     -100
#define CTK_EFFECT_DROP_SHADOW_MAX_OFFSET_Y      100
#define CTK_EFFECT_DROP_SHADOW_DEFAULT_OFFSET_Y    0

#define CTK_TYPE_EFFECT_DROP_SHADOW (ctk_effect_drop_shadow_get_type ())

#define CTK_EFFECT_DROP_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_EFFECT_DROP_SHADOW, CtkEffectDropShadow))

#define CTK_EFFECT_DROP_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_EFFECT_DROP_SHADOW, CtkEffectDropShadowClass))

#define CTK_IS_EFFECT_DROP_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_EFFECT_DROP_SHADOW))

#define CTK_IS_EFFECT_DROP_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_EFFECT_DROP_SHADOW))

#define CTK_EFFECT_DROP_SHADOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_EFFECT_DROP_SHADOW, CtkEffectDropShadowClass))

typedef struct _CtkEffectDropShadow        CtkEffectDropShadow;
typedef struct _CtkEffectDropShadowClass   CtkEffectDropShadowClass;
typedef struct _CtkEffectDropShadowPrivate CtkEffectDropShadowPrivate;

struct _CtkEffectDropShadow
{
  CtkEffect                   parent;
  CtkEffectDropShadowPrivate* priv;
};

struct _CtkEffectDropShadowClass
{
  /*< private >*/
  CtkEffectClass parent_class;
  
  void (*_drop_shadow_padding1) (void);
  void (*_drop_shadow_padding2) (void);
  void (*_drop_shadow_padding3) (void);
  void (*_drop_shadow_padding4) (void);
  void (*_drop_shadow_padding5) (void);
  void (*_drop_shadow_padding6) (void);
};

GType
ctk_effect_drop_shadow_get_type (void) G_GNUC_CONST;

CtkEffectDropShadow*
ctk_effect_drop_shadow_new (gfloat blurfactor,
			    gint  offset_x,
			    gint  offset_y);

void
ctk_effect_drop_shadow_set_blur_factor (CtkEffectDropShadow* drop_shadow,
				 gfloat                size);

gfloat
ctk_effect_drop_shadow_get_blur_factor (CtkEffectDropShadow* drop_shadow);

void
ctk_effect_drop_shadow_set_offset_x (CtkEffectDropShadow* drop_shadow,
				     gint                 offset_x);

gint
ctk_effect_drop_shadow_get_offset_x (CtkEffectDropShadow* drop_shadow);

void
ctk_effect_drop_shadow_set_offset_y (CtkEffectDropShadow* drop_shadow,
				     gint                 offset_y);

gint
ctk_effect_drop_shadow_get_offset_y (CtkEffectDropShadow* drop_shadow);

G_END_DECLS

#endif /* _CTK_EFFECT_DROP_SHADOW_H_ */
