/*
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Mirco Müller <mirco.mueller@canonical.com>
 */

#ifndef _CTK_LAYER_ACTOR_H_
#define _CTK_LAYER_ACTOR_H_

#include <glib.h>
#include <clutter/clutter.h>
#include "ctk-layer.h"

G_BEGIN_DECLS

#define CTK_TYPE_LAYER_ACTOR (ctk_layer_actor_get_type ())

#define CTK_LAYER_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_LAYER_ACTOR, CtkLayerActor))

#define CTK_LAYER_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_LAYER_ACTOR, CtkLayerActorClass))

#define CTK_IS_LAYER_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_LAYER_ACTOR))

#define CTK_IS_LAYER_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_LAYER_ACTOR))

#define CTK_LAYER_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_LAYER_ACTOR, CtkLayerActorClass))

typedef struct _CtkLayerActor        CtkLayerActor;
typedef struct _CtkLayerActorClass   CtkLayerActorClass;
typedef struct _CtkLayerActorPrivate CtkLayerActorPrivate;

struct _CtkLayerActor
{
  CtkActor parent;

  CtkLayerActorPrivate* priv;
};

struct _CtkLayerActorClass
{
  CtkActorClass parent_class;
  
  /*< private >*/
  void (*_layer_actor_padding1) (void);
  void (*_layer_actor_padding2) (void);
  void (*_layer_actor_padding3) (void);
  void (*_layer_actor_padding4) (void);
  void (*_layer_actor_padding5) (void);
  void (*_layer_actor_padding6) (void);
};

GType
ctk_layer_actor_get_type (void) G_GNUC_CONST;

ClutterActor*
ctk_layer_actor_new (guint width,
                     guint height);

guint
ctk_layer_actor_get_width (CtkLayerActor* self);

void
ctk_layer_actor_set_width (CtkLayerActor* self,
                           guint          width);

guint
ctk_layer_actor_get_height (CtkLayerActor* self);

void
ctk_layer_actor_set_height (CtkLayerActor* self,
                            guint          height);

guint
ctk_layer_actor_get_num_layers (CtkLayerActor* self);

void
ctk_layer_actor_add_layer (CtkLayerActor* self,
                           CtkLayer*      layer);

CtkLayer*
ctk_layer_actor_get_layer (CtkLayerActor* self,
                           guint          index);

void
ctk_layer_actor_flatten (CtkLayerActor* self);

gboolean
ctk_layer_actor_is_flattened (CtkLayerActor* self);

G_END_DECLS

#endif /* _CTK_LAYER_ACTOR_H_ */
