/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Mirco Müller <mirco.mueller@canonical.com>
 *
 */

#ifndef _CTK_MENU_EXPANDABLE_H_
#define _CTK_MENU_EXPANDABLE_H_

#include <glib.h>
#include <clutk/ctk-actor.h>
#include <clutter/clutter.h>
#include "ctk-menu.h"

G_BEGIN_DECLS

#define CTK_TYPE_MENU_EXPANDABLE (ctk_menu_expandable_get_type ())

#define CTK_MENU_EXPANDABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
  CTK_TYPE_MENU_EXPANDABLE, CtkMenuExpandable))

#define CTK_MENU_EXPANDABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
  CTK_TYPE_MENU_EXPANDABLE, CtkMenuExpandableClass))

#define CTK_IS_MENU_EXPANDABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
  CTK_TYPE_MENU_EXPANDABLE))

#define CTK_IS_MENU_EXPANDABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
  CTK_TYPE_MENU_EXPANDABLE))

#define CTK_MENU_EXPANDABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
  CTK_TYPE_MENU_EXPANDABLE, CtkMenuExpandableClass))

#define CTK_MENU_EXPANDABLE_TRANSITION_STEPS    8
#define CTK_MENU_EXPANDABLE_PADDING             16
#define CTK_MENU_EXPANDABLE_CONTENT_PADDING     0
#define CTK_MENU_EXPANDABLE_CONTENT_PADDING_LEFT_RIGHT     4
#define CTK_MENU_EXPANDABLE_ANCHOR_SIZE_OFFSET  4
#define CTK_MENU_EXPANDABLE_ANCHOR_WIDTH        10.0f
#define CTK_MENU_EXPANDABLE_ANCHOR_HEIGHT       18.0f
#define CTK_MENU_EXPANDABLE_CORNER_RADIUS       5.0f

typedef struct _CtkMenuExpandable         CtkMenuExpandable;
typedef struct _CtkMenuExpandableClass    CtkMenuExpandableClass;
typedef struct _CtkMenuExpandablePrivate  CtkMenuExpandablePrivate;

struct _CtkMenuExpandable
{
  CtkMenu parent;

  CtkMenuExpandablePrivate *priv;
};

struct _CtkMenuExpandableClass
{
  /*< private >*/
  CtkMenuClass parent_class;

  /*< signals />*/
};

GType ctk_menu_expandable_get_type (void) G_GNUC_CONST;

CtkMenuExpandable*
ctk_menu_expandable_new (void);

guint
ctk_menu_expandable_get_bg_fill_image_id (CtkMenuExpandable* self);

guint
ctk_menu_expandable_get_bg_fill_image_width (CtkMenuExpandable* self);

guint
ctk_menu_expandable_get_bg_fill_image_height (CtkMenuExpandable* self);

void
ctk_menu_expandable_set_bg_fill_image_id (CtkMenuExpandable* self,
                                          guint              image_id);

void
ctk_menu_expandable_set_bg_fill_image_width (CtkMenuExpandable* self,
                                             guint              width);

void
ctk_menu_expandable_set_bg_fill_image_height (CtkMenuExpandable* self,
                                              guint              height);
                                              
void
ctk_menu_expandable_set_transition_textures (CtkMenuExpandable* self,
                                            int index,
                                            cairo_surface_t*   surf,
                                            cairo_surface_t*   mask_surf);

void
ctk_menu_expandable_set_full_textures (CtkMenuExpandable* self,
                                            cairo_surface_t*   surf,
                                            cairo_surface_t*   mask_surf);

guint
ctk_menu_expandable_get_transition_steps (CtkMenuExpandable* self);

void
ctk_menu_expandable_set_padding (CtkMenuExpandable* self, gint padding);

guint
ctk_menu_expandable_get_padding (CtkMenuExpandable* self);

void
ctk_menu_expandable_set_content_padding (CtkMenuExpandable* self, gint padding);

gint
ctk_menu_expandable_get_content_padding (CtkMenuExpandable* self);

gint
ctk_menu_expandable_get_content_padding_left_right (CtkMenuExpandable* self);

void
ctk_menu_expandable_set_content_padding_left_right (CtkMenuExpandable* self, gint padding);

guint
ctk_menu_expandable_get_anchor_size_offset (CtkMenuExpandable* self);

guint
ctk_menu_expandable_get_anchor_width (CtkMenuExpandable* self);

guint
ctk_menu_expandable_get_anchor_height (CtkMenuExpandable* self);

guint
ctk_menu_expandable_get_corner_radius (CtkMenuExpandable* self);

void
ctk_menu_expandable_compute_style_textures (CtkMenuExpandable* self);

void
ctk_menu_expandable_set_anchor_position (CtkMenuExpandable* self, gfloat x, gfloat y, gint tooltip_y_in_menu);

void
ctk_menu_expandable_set_expansion_size_factor (CtkMenuExpandable* self, gfloat factor);

gfloat
ctk_menu_expandable_get_expansion_size_factor (CtkMenuExpandable* self);


G_END_DECLS

#endif /* _CTK_MENU_EXPANDABLE_H_ */

