/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mirco Müller <mirco.mueller@canonical.com>
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <unistd.h>
#include <clutk/clutk.h>

static void test_em_to_pixel (void);
static void test_pixel_to_em (void);

void
test_em_support_create_suite (void)
{
#define DOMAIN "/EM"

  g_test_add_func (DOMAIN"/em-to-pixel", test_em_to_pixel);
  g_test_add_func (DOMAIN"/pixel-to-em", test_pixel_to_em);
}

static void
test_em_to_pixel (void)
{
  g_assert_cmpfloat (ctk_em_to_pixel (1.0f), >, 0.0f);
}

static void
test_pixel_to_em (void)
{
  g_assert_cmpfloat (ctk_pixel_to_em (10.0f), >, 0.0f);
}
