# Copyright (C) 2008, 2009, 2010  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Test suite for Computer Janitor daemon (dbus backend)."""

from __future__ import absolute_import, unicode_literals

__metaclass__ = type
__all__ = [
    'test_suite',
    ]


import unittest

from computerjanitord.tests import test_application
from computerjanitord.tests import test_authenticator
from computerjanitord.tests import test_collector
from computerjanitord.tests import test_state
from computerjanitord.tests import test_whitelist


def test_suite():
    suite = unittest.TestSuite()
    suite.addTests(test_application.test_suite())
    suite.addTests(test_authenticator.test_suite())
    suite.addTests(test_collector.test_suite())
    suite.addTests(test_state.test_suite())
    suite.addTests(test_whitelist.test_suite())
    return suite
