/*
 * Decibel Demo
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <QtCore/QStringList>
#include <QtCore/QDebug>
#include <QtCore/QCoreApplication>
#include <QtDBus/QDBusConnection>

#include <Decibel/AccountManager>
#include <Decibel/DBusNames>

// Simplistic demo to remove an account
// (bringing it online/offline when necessary).
// Usage: $0 accounthandle

int main(int argc, char ** argv)
{
    QCoreApplication app(argc, argv);

    Q_ASSERT(argc == 2);

    QString account_handle_string(argv[1]);

    int account_handle = account_handle_string.toInt();
    if (account_handle <= 0)
    {
        qDebug("Invalid account handle given (not a number?).");
        return 10;
    }

    // Connect to session bus:
    if (!QDBusConnection::sessionBus().isConnected())
    {
        qDebug("Cannot connect to the D-BUS session bus.\n"
               "To start it, run:\n"
               "\teval `dbus-launch --auto-syntax`\n");
        return 1;
    }

    // Register custom types:
    Decibel::registerTypes();

    // connect to the Decibel daemon:
    org::kde::Decibel::AccountManager
    account_mgr(Decibel::daemon_service, Decibel::daemon_accountmanager_path,
                QDBusConnection::sessionBus(), &app);

    QDBusReply<void> reply = account_mgr.deleteAccount(account_handle);
    if (!reply.isValid())
    {
        QDBusError error = reply.error();
        qDebug() << "DBus Error while removing an account:"
                 << error.type() << ":"
                 << error.message();
        return 3;
    }

    return 0;
}
