/*
 * A Decibel Demo
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "mytextchannelhandler.h"

#include <QtCore/QDebug>

MyTextChannelHandler::MyTextChannelHandler(QObject * parent) :
    ChannelHandler(parent),
    m_connection(0),
    m_channel(0)
{ }

MyTextChannelHandler::~MyTextChannelHandler()
{ }


bool MyTextChannelHandler::handleChannel(QtTapioca::Connection * connection,
                                         QtTapioca::Channel * channel,
                                         const bool)
{
    Q_ASSERT(connection != 0);
    Q_ASSERT(channel != 0);

    qDebug() << "SimpleClient::MyTextChannelHandler called!";


    if (m_connection != 0) { return false; }

    m_channel = dynamic_cast<QtTapioca::TextChannel*>(channel);
    if (m_channel == 0)
    {
        qDebug() << "SimpleClient::MyTextChannelHandler: Not a textchannel, ignore!";
        return false;
    }
    m_connection = connection;

    connect(m_channel, SIGNAL(messageReceived(QtTapioca::TextChannel *,QtTapioca::TextChannel::Message)),
            this, SLOT(onMessageReceived()));
    connect(m_channel, SIGNAL(closed()), this, SLOT(onCloseChannel()));

    onMessageReceived();

    return true;
}

void MyTextChannelHandler::onCloseChannel()
{
    m_connection = 0;
    m_channel = 0;
}

void MyTextChannelHandler::onMessageReceived()
{
    QList<QtTapioca::TextChannel::Message> message_list = m_channel->pendingMessages();

    // use iterators since TextChannel::Message has no default constructor yet...
    for (QList<QtTapioca::TextChannel::Message>::const_iterator
             message = message_list.constBegin();
         message != message_list.constEnd(); ++message)
    {
        if (message->type() == QtTapioca::TextChannel::Message::Normal &&
            message->contents() == QString("ping?"))
        { m_channel->sendMessage(QString("pong!")); }

        m_channel->acknowledge(*message);
    }
}

