/*
 * This is a helper library to ease testing of D-Bus objects.
 * Copyright (C) 2008 by Tobias Hunger <tobias@aquazul.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef TESTS_DBUSTEST_DBUSTESTCASE_H
#define TESTS_DBUSTEST_DBUSTESTCASE_H

// Actually not needed here... but if I leave it out I
// keep forgetting to add it to the testcases later;-)
#include <QtTest/QtTest>

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtCore/QTime>

class DBusTestCasePrivate;

class DBusTestCase : public QObject
{
    Q_OBJECT
public:
    struct DBusSignal
    {
        QTime time_stamp;
        QObject * object;
        QByteArray signal;
        QList<QVariant> parameters;
    };

    DBusTestCase(bool private_dbus = true,
                 QObject * parent = 0);
    virtual ~DBusTestCase();

protected:
    QList<DBusSignal> recentSignals();
    void startAUT(const QString & app,
                  const QStringList & arguments = QStringList());
    void stopAUTs();

protected Q_SLOTS:
    virtual void initTestCase();
    virtual void cleanupTestCase();

private:
    DBusTestCasePrivate * const d;
};

#endif // header guard
