<?xml version="1.0"?>
<api version="1.0">
	<namespace name="Dee">
		<callback name="DeeAnalyzerFunc">
			<return-type type="void"/>
			<parameters>
				<parameter name="model" type="DeeModel*"/>
				<parameter name="iter" type="DeeModelIter*"/>
				<parameter name="out_terms" type="DeeTermList*"/>
				<parameter name="userdata" type="gpointer"/>
			</parameters>
		</callback>
		<callback name="DeeIndexIterFunc">
			<return-type type="gboolean"/>
			<parameters>
				<parameter name="key" type="gchar*"/>
				<parameter name="rows" type="DeeResultSet*"/>
				<parameter name="userdata" type="gpointer"/>
			</parameters>
		</callback>
		<callback name="DeeModelMapFunc">
			<return-type type="void"/>
			<parameters>
				<parameter name="orig_model" type="DeeModel*"/>
				<parameter name="filter_model" type="DeeFilterModel*"/>
				<parameter name="user_data" type="gpointer"/>
			</parameters>
		</callback>
		<callback name="DeeModelMapNotify">
			<return-type type="void"/>
			<parameters>
				<parameter name="orig_model" type="DeeModel*"/>
				<parameter name="orig_iter" type="DeeModelIter*"/>
				<parameter name="filter_model" type="DeeFilterModel*"/>
				<parameter name="user_data" type="gpointer"/>
			</parameters>
		</callback>
		<struct name="DeeAnalyzer">
			<method name="new_for_full_text_column" symbol="dee_analyzer_new_for_full_text_column">
				<return-type type="DeeAnalyzer*"/>
				<parameters>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="new_for_int_column" symbol="dee_analyzer_new_for_int_column">
				<return-type type="DeeAnalyzer*"/>
				<parameters>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="new_for_key_column" symbol="dee_analyzer_new_for_key_column">
				<return-type type="DeeAnalyzer*"/>
				<parameters>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="new_for_uint_column" symbol="dee_analyzer_new_for_uint_column">
				<return-type type="DeeAnalyzer*"/>
				<parameters>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<field name="analyze" type="DeeAnalyzerFunc"/>
			<field name="userdata" type="gpointer"/>
			<field name="destroy" type="GDestroyNotify"/>
		</struct>
		<struct name="DeeFilter">
			<field name="map_func" type="DeeModelMapFunc"/>
			<field name="map_notify" type="DeeModelMapNotify"/>
			<field name="destroy" type="GDestroyNotify"/>
			<field name="user_data" type="gpointer"/>
		</struct>
		<struct name="DeeModelIter">
		</struct>
		<enum name="DeeSeqnumState">
			<member name="DEE_SEQNUM_STATE_NOT_CONSECUTIVE" value="0"/>
			<member name="DEE_SEQNUM_STATE_IN_THE_FUTURE" value="1"/>
			<member name="DEE_SEQNUM_STATE_IN_THE_PAST" value="2"/>
			<member name="DEE_SEQNUM_STATE_OK" value="3"/>
		</enum>
		<enum name="DeeSharedModelError">
			<member name="DEE_SHARED_MODEL_ERROR_LEADER_INVALIDATED" value="0"/>
		</enum>
		<enum name="DeeTermMatchFlag">
			<member name="DEE_TERM_MATCH_EXACT" value="0"/>
			<member name="DEE_TERM_MATCH_PREFIX" value="2"/>
		</enum>
		<object name="DeeFilterModel" parent="DeeProxyModel" type-name="DeeFilterModel" get-type="dee_filter_model_get_type">
			<implements>
				<interface name="DeeModel"/>
			</implements>
			<method name="append_iter" symbol="dee_filter_model_append_iter">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeFilterModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="contains" symbol="dee_filter_model_contains">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeFilterModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="insert_iter" symbol="dee_filter_model_insert_iter">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeFilterModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</method>
			<method name="insert_iter_before" symbol="dee_filter_model_insert_iter_before">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeFilterModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="pos" type="DeeModelIter*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="dee_filter_model_new">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="filter" type="DeeFilter*"/>
					<parameter name="orig_model" type="DeeModel*"/>
				</parameters>
			</constructor>
			<method name="prepend_iter" symbol="dee_filter_model_prepend_iter">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeFilterModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<property name="filter" type="gpointer" readable="1" writable="1" construct="0" construct-only="1"/>
		</object>
		<object name="DeeIndex" parent="GObject" type-name="DeeIndex" get-type="dee_index_get_type">
			<method name="foreach" symbol="dee_index_foreach">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
					<parameter name="start_term" type="gchar*"/>
					<parameter name="func" type="DeeIndexIterFunc"/>
					<parameter name="userdata" type="gpointer"/>
				</parameters>
			</method>
			<method name="get_analyzer" symbol="dee_index_get_analyzer">
				<return-type type="DeeAnalyzer*"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</method>
			<method name="get_model" symbol="dee_index_get_model">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</method>
			<method name="get_n_rows" symbol="dee_index_get_n_rows">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</method>
			<method name="get_n_rows_for_term" symbol="dee_index_get_n_rows_for_term">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
					<parameter name="term" type="gchar*"/>
				</parameters>
			</method>
			<method name="get_n_terms" symbol="dee_index_get_n_terms">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</method>
			<method name="get_supported_term_match_flags" symbol="dee_index_get_supported_term_match_flags">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</method>
			<method name="lookup" symbol="dee_index_lookup">
				<return-type type="DeeResultSet*"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
					<parameter name="term" type="gchar*"/>
					<parameter name="flags" type="DeeTermMatchFlag"/>
				</parameters>
			</method>
			<property name="analyzer" type="gpointer" readable="1" writable="1" construct="0" construct-only="1"/>
			<property name="model" type="DeeModel*" readable="1" writable="1" construct="0" construct-only="1"/>
			<vfunc name="foreach">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
					<parameter name="start_term" type="gchar*"/>
					<parameter name="func" type="DeeIndexIterFunc"/>
					<parameter name="userdata" type="gpointer"/>
				</parameters>
			</vfunc>
			<vfunc name="get_n_rows">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_n_rows_for_term">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
					<parameter name="term" type="gchar*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_n_terms">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_supported_term_match_flags">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
				</parameters>
			</vfunc>
			<vfunc name="lookup">
				<return-type type="DeeResultSet*"/>
				<parameters>
					<parameter name="self" type="DeeIndex*"/>
					<parameter name="term" type="gchar*"/>
					<parameter name="flags" type="DeeTermMatchFlag"/>
				</parameters>
			</vfunc>
		</object>
		<object name="DeePeer" parent="GObject" type-name="DeePeer" get-type="dee_peer_get_type">
			<method name="connect" symbol="dee_peer_connect">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeePeer*"/>
				</parameters>
			</method>
			<method name="get_swarm_leader" symbol="dee_peer_get_swarm_leader">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeePeer*"/>
				</parameters>
			</method>
			<method name="get_swarm_name" symbol="dee_peer_get_swarm_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeePeer*"/>
				</parameters>
			</method>
			<method name="is_swarm_leader" symbol="dee_peer_is_swarm_leader">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeePeer*"/>
				</parameters>
			</method>
			<property name="swarm-leader" type="char*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="swarm-name" type="char*" readable="1" writable="1" construct="1" construct-only="0"/>
			<signal name="bye" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="DeePeer*"/>
					<parameter name="p0" type="char*"/>
					<parameter name="p1" type="char*"/>
				</parameters>
			</signal>
			<signal name="connected" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="peer" type="DeePeer*"/>
					<parameter name="peer_name" type="char*"/>
				</parameters>
			</signal>
			<signal name="peer-found" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="peer" type="DeePeer*"/>
					<parameter name="name" type="char*"/>
				</parameters>
			</signal>
			<signal name="peer-lost" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="peer" type="DeePeer*"/>
					<parameter name="name" type="char*"/>
				</parameters>
			</signal>
			<signal name="ping" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="DeePeer*"/>
					<parameter name="p0" type="char*"/>
				</parameters>
			</signal>
			<signal name="pong" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="DeePeer*"/>
					<parameter name="p0" type="char*"/>
				</parameters>
			</signal>
		</object>
		<object name="DeeProxyModel" parent="DeeVersionedModel" type-name="DeeProxyModel" get-type="dee_proxy_model_get_type">
			<implements>
				<interface name="DeeModel"/>
			</implements>
			<property name="back-end" type="DeeModel*" readable="1" writable="1" construct="0" construct-only="1"/>
			<property name="proxy-signals" type="gboolean" readable="1" writable="1" construct="0" construct-only="1"/>
		</object>
		<object name="DeeSequenceModel" parent="DeeVersionedModel" type-name="DeeSequenceModel" get-type="dee_sequence_model_get_type">
			<implements>
				<interface name="DeeModel"/>
			</implements>
			<constructor name="new" symbol="dee_sequence_model_new">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="n_columns" type="guint"/>
				</parameters>
			</constructor>
		</object>
		<object name="DeeSharedModel" parent="DeeProxyModel" type-name="DeeSharedModel" get-type="dee_shared_model_get_type">
			<implements>
				<interface name="DeeModel"/>
			</implements>
			<method name="connect" symbol="dee_shared_model_connect">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeSharedModel*"/>
				</parameters>
			</method>
			<method name="get_peer" symbol="dee_shared_model_get_peer">
				<return-type type="DeePeer*"/>
				<parameters>
					<parameter name="self" type="DeeSharedModel*"/>
				</parameters>
			</method>
			<method name="get_swarm_name" symbol="dee_shared_model_get_swarm_name">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeeSharedModel*"/>
				</parameters>
			</method>
			<constructor name="new" symbol="dee_shared_model_new">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="name" type="gchar*"/>
					<parameter name="n_columns" type="guint"/>
				</parameters>
			</constructor>
			<constructor name="new_with_back_end" symbol="dee_shared_model_new_with_back_end">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="name" type="gchar*"/>
					<parameter name="back_end" type="DeeModel*"/>
				</parameters>
			</constructor>
			<constructor name="new_with_name" symbol="dee_shared_model_new_with_name">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="name" type="gchar*"/>
				</parameters>
			</constructor>
			<property name="columns" type="char*" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="peer" type="DeePeer*" readable="1" writable="1" construct="0" construct-only="1"/>
			<property name="seqnum" type="guint64" readable="1" writable="0" construct="0" construct-only="0"/>
			<property name="size" type="guint" readable="1" writable="0" construct="0" construct-only="0"/>
			<signal name="ready" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="DeeSharedModel*"/>
				</parameters>
			</signal>
			<signal name="rows-added" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="DeeSharedModel*"/>
					<parameter name="p0" type="GPtrArray_GPtrArray_GValue__*"/>
					<parameter name="p1" type="GArray_guint_*"/>
					<parameter name="p2" type="GArray_guint64_*"/>
				</parameters>
			</signal>
			<signal name="rows-changed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="DeeSharedModel*"/>
					<parameter name="p0" type="GPtrArray_GPtrArray_GValue__*"/>
					<parameter name="p1" type="GArray_guint_*"/>
					<parameter name="p2" type="GArray_guint64_*"/>
				</parameters>
			</signal>
			<signal name="rows-removed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="object" type="DeeSharedModel*"/>
					<parameter name="p0" type="GArray_guint_*"/>
					<parameter name="p1" type="GArray_guint64_*"/>
				</parameters>
			</signal>
		</object>
		<object name="DeeTermList" parent="GObject" type-name="DeeTermList" get-type="dee_term_list_get_type">
			<method name="add_term" symbol="dee_term_list_add_term">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
					<parameter name="key" type="gchar*"/>
				</parameters>
			</method>
			<method name="clear" symbol="dee_term_list_clear">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
				</parameters>
			</method>
			<method name="get_term" symbol="dee_term_list_get_term">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
					<parameter name="n" type="guint"/>
				</parameters>
			</method>
			<method name="num_terms" symbol="dee_term_list_num_terms">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
				</parameters>
			</method>
			<vfunc name="add_term">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
					<parameter name="term" type="gchar*"/>
				</parameters>
			</vfunc>
			<vfunc name="clear">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_term">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
					<parameter name="n" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="num_terms">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeTermList*"/>
				</parameters>
			</vfunc>
		</object>
		<object name="DeeVersionedModel" parent="GObject" type-name="DeeVersionedModel" get-type="dee_versioned_model_get_type">
			<implements>
				<interface name="DeeModel"/>
			</implements>
			<method name="append_next_seqnum" symbol="dee_versioned_model_append_next_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="check_seqnum" symbol="dee_versioned_model_check_seqnum">
				<return-type type="DeeSeqnumState"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="seqnum" type="guint64"/>
				</parameters>
			</method>
			<method name="check_seqnums" symbol="dee_versioned_model_check_seqnums">
				<return-type type="DeeSeqnumState"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="seqnums" type="GArray*"/>
				</parameters>
			</method>
			<method name="get_last_seqnum" symbol="dee_versioned_model_get_last_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="get_seqnum" symbol="dee_versioned_model_get_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</method>
			<method name="inc_seqnum" symbol="dee_versioned_model_inc_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</method>
			<method name="insert_next_seqnum" symbol="dee_versioned_model_insert_next_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</method>
			<method name="prepend_next_seqnum" symbol="dee_versioned_model_prepend_next_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="remove_seqnum" symbol="dee_versioned_model_remove_seqnum">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</method>
			<method name="set_last_seqnum" symbol="dee_versioned_model_set_last_seqnum">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="seqnum" type="guint64"/>
				</parameters>
			</method>
			<method name="set_seqnum" symbol="dee_versioned_model_set_seqnum">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
					<parameter name="seqnum" type="guint64"/>
				</parameters>
			</method>
			<vfunc name="append_next_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="check_seqnum">
				<return-type type="DeeSeqnumState"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="seqnum" type="guint64"/>
				</parameters>
			</vfunc>
			<vfunc name="check_seqnums">
				<return-type type="DeeSeqnumState"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="seqnums" type="GArray*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_last_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="inc_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="insert_next_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="prepend_next_seqnum">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="remove_seqnum">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="set_last_seqnum">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="seqnum" type="guint64"/>
				</parameters>
			</vfunc>
			<vfunc name="set_seqnum">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="guint"/>
					<parameter name="seqnum" type="guint64"/>
				</parameters>
			</vfunc>
		</object>
		<interface name="DeeModel" type-name="DeeModel" get-type="dee_model_get_type">
			<requires>
				<interface name="GObject"/>
			</requires>
			<method name="append" symbol="dee_model_append">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="append_valist" symbol="dee_model_append_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</method>
			<method name="build_col_spec" symbol="dee_model_build_col_spec">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="check_type" symbol="dee_model_check_type">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="type" type="GType"/>
				</parameters>
			</method>
			<method name="clear" symbol="dee_model_clear">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="freeze_signals" symbol="dee_model_freeze_signals">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="get" symbol="dee_model_get">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="get_bool" symbol="dee_model_get_bool">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_column_type" symbol="dee_model_get_column_type">
				<return-type type="GType"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_double" symbol="dee_model_get_double">
				<return-type type="gdouble"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_first_iter" symbol="dee_model_get_first_iter">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="get_int" symbol="dee_model_get_int">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_int64" symbol="dee_model_get_int64">
				<return-type type="gint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_iter_at_row" symbol="dee_model_get_iter_at_row">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="row" type="guint"/>
				</parameters>
			</method>
			<method name="get_last_iter" symbol="dee_model_get_last_iter">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="get_n_columns" symbol="dee_model_get_n_columns">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="get_n_rows" symbol="dee_model_get_n_rows">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="get_position" symbol="dee_model_get_position">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="get_string" symbol="dee_model_get_string">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_type_for_signature" symbol="dee_model_get_type_for_signature">
				<return-type type="GType"/>
				<parameters>
					<parameter name="chr" type="gchar"/>
				</parameters>
			</method>
			<method name="get_uchar" symbol="dee_model_get_uchar">
				<return-type type="guchar"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_uint" symbol="dee_model_get_uint">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_uint64" symbol="dee_model_get_uint64">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</method>
			<method name="get_valist" symbol="dee_model_get_valist">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</method>
			<method name="get_value" symbol="dee_model_get_value">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
					<parameter name="value" type="GValue*"/>
				</parameters>
			</method>
			<method name="insert" symbol="dee_model_insert">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="gint"/>
				</parameters>
			</method>
			<method name="insert_before" symbol="dee_model_insert_before">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="insert_before_valist" symbol="dee_model_insert_before_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</method>
			<method name="insert_valist" symbol="dee_model_insert_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="gint"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</method>
			<method name="is_first" symbol="dee_model_is_first">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="is_last" symbol="dee_model_is_last">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="next" symbol="dee_model_next">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="prepend" symbol="dee_model_prepend">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<method name="prepend_valist" symbol="dee_model_prepend_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</method>
			<method name="prev" symbol="dee_model_prev">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="remove" symbol="dee_model_remove">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="set" symbol="dee_model_set">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</method>
			<method name="set_column_type" symbol="dee_model_set_column_type">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="column" type="guint"/>
					<parameter name="type" type="GType"/>
				</parameters>
			</method>
			<method name="set_n_columns" symbol="dee_model_set_n_columns">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="n_columns" type="guint"/>
				</parameters>
			</method>
			<method name="set_valist" symbol="dee_model_set_valist">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</method>
			<method name="set_value" symbol="dee_model_set_value">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
					<parameter name="value" type="GValue*"/>
				</parameters>
			</method>
			<method name="set_value_silently" symbol="dee_model_set_value_silently">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
					<parameter name="value" type="GValue*"/>
				</parameters>
			</method>
			<method name="thaw_signals" symbol="dee_model_thaw_signals">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</method>
			<signal name="row-added" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="gpointer"/>
				</parameters>
			</signal>
			<signal name="row-changed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="gpointer"/>
				</parameters>
			</signal>
			<signal name="row-removed" when="LAST">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="gpointer"/>
				</parameters>
			</signal>
			<vfunc name="append_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</vfunc>
			<vfunc name="clear">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="freeze_signals">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_bool">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_column_type">
				<return-type type="GType"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_double">
				<return-type type="gdouble"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_first_iter">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_int">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_int64">
				<return-type type="gint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_iter_at_row">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="row" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_last_iter">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_n_columns">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_n_rows">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_position">
				<return-type type="gint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_string">
				<return-type type="gchar*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_uchar">
				<return-type type="guchar"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_uint">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_uint64">
				<return-type type="guint64"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="get_valist">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</vfunc>
			<vfunc name="get_value">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
					<parameter name="value" type="GValue*"/>
				</parameters>
			</vfunc>
			<vfunc name="insert_before_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</vfunc>
			<vfunc name="insert_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="pos" type="gint"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</vfunc>
			<vfunc name="is_first">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</vfunc>
			<vfunc name="is_last">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</vfunc>
			<vfunc name="next">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</vfunc>
			<vfunc name="prepend_valist">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</vfunc>
			<vfunc name="prev">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</vfunc>
			<vfunc name="remove">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
				</parameters>
			</vfunc>
			<vfunc name="set_column_type">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="column" type="guint"/>
					<parameter name="type" type="GType"/>
				</parameters>
			</vfunc>
			<vfunc name="set_n_columns">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="n_columns" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="set_valist">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="args" type="va_list"/>
				</parameters>
			</vfunc>
			<vfunc name="set_value">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
					<parameter name="value" type="GValue*"/>
				</parameters>
			</vfunc>
			<vfunc name="set_value_silently">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
					<parameter name="iter" type="DeeModelIter*"/>
					<parameter name="column" type="guint"/>
					<parameter name="value" type="GValue*"/>
				</parameters>
			</vfunc>
			<vfunc name="thaw_signals">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeModel*"/>
				</parameters>
			</vfunc>
		</interface>
		<interface name="DeeResultSet" type-name="DeeResultSet" get-type="dee_result_set_get_type">
			<requires>
				<interface name="GObject"/>
			</requires>
			<method name="get_model" symbol="dee_result_set_get_model">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</method>
			<method name="get_n_rows" symbol="dee_result_set_get_n_rows">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</method>
			<method name="has_next" symbol="dee_result_set_has_next">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</method>
			<method name="next" symbol="dee_result_set_next">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</method>
			<method name="peek" symbol="dee_result_set_peek">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</method>
			<method name="seek" symbol="dee_result_set_seek">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</method>
			<method name="tell" symbol="dee_result_set_tell">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</method>
			<vfunc name="get_model">
				<return-type type="DeeModel*"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</vfunc>
			<vfunc name="get_n_rows">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</vfunc>
			<vfunc name="has_next">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</vfunc>
			<vfunc name="next">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</vfunc>
			<vfunc name="peek">
				<return-type type="DeeModelIter*"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</vfunc>
			<vfunc name="seek">
				<return-type type="void"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
					<parameter name="pos" type="guint"/>
				</parameters>
			</vfunc>
			<vfunc name="tell">
				<return-type type="guint"/>
				<parameters>
					<parameter name="self" type="DeeResultSet*"/>
				</parameters>
			</vfunc>
		</interface>
		<constant name="DEE_PEER_DBUS_IFACE" type="char*" value="com.canonical.Dee.Peer"/>
		<constant name="DEE_SEQUENCE_MODEL_DBUS_IFACE" type="char*" value="com.canonical.Dee.Model"/>
		<constant name="DEE_SHARED_MODEL_DBUS_IFACE" type="char*" value="com.canonical.Dee.Model"/>
	</namespace>
</api>
