/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 */

#if !defined (_DEE_H_INSIDE) && !defined (DEE_COMPILATION)
#error "Only <dee.h> can be included directly."
#endif

#ifndef _HAVE_DEE_ANALYZERS_H
#define _HAVE_DEE_ANALYZERS_H

#include <glib.h>
#include <glib-object.h>
#include <dee-index.h>

G_BEGIN_DECLS

DeeAnalyzer* dee_analyzer_new_for_key_column    (guint column);

DeeAnalyzer* dee_analyzer_new_for_full_text_column (guint column);

DeeAnalyzer* dee_analyzer_new_for_int32_column (guint column);

DeeAnalyzer* dee_analyzer_new_for_uint32_column (guint column);

G_END_DECLS

#endif /* _HAVE_DEE_ANALYZERS_H */
