/* scoreops.cpp
 * functions dealing with the whole score

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2000-2005 Matthew Hiller, Adam Tee*/

#include <denemo/denemo.h>
#include <stdio.h>
#include "staffops.h"
#include "scoreops.h"
#define INITIAL_WHOLEWIDTH 160
#define INITIAL_STAFFHEIGHT 100


/**
 * Create new DenemoScore
 * 
 */
DenemoScore *
new_score (gchar *lilyversion)
{
  DenemoScore *newscore = (DenemoScore *) g_malloc0 (sizeof (DenemoScore));
  init_score (newscore, lilyversion);

  return newscore;
}


/**
 * Initialise scoreinfo structure 
 *
 * @param si pointer to the scoreinfo structure to initialise
 */
void
init_score (DenemoScore * si, gchar * lilyversion)
{
  gchar *dir = locatedotdenemo ();
  si->readonly = 0;
  si->leftmeasurenum = si->rightmeasurenum = 1;
  si->top_staff = si->bottom_staff = 1;
  si->measurewidth = INITIAL_WHOLEWIDTH;
  si->measurewidths = NULL;
  si->staffspace = INITIAL_STAFFHEIGHT;
  si->config = NULL;
  si->thescore = NULL;
  si->currentstaffnum = 1;
  si->currentmeasurenum = 1;
  si->currentobject = NULL;
  si->cursor_x = 0;
  si->cursor_y = 0;
  si->staffletter_y = 0;
  si->cursor_appending = TRUE;

  si->cursoroffend = FALSE;
  si->cursortime1=si->cursortime2=4;
  si->markstaffnum = 0;
  si->markmeasurenum = 0;
  si->markcursor_x = 0;
  si->maxkeywidth = 0;
  si->haschanged = FALSE;
  si->is_grace_mode = FALSE;
  si->has_figures = FALSE;
  si->has_fakechords = FALSE;
  /*playback purposes */
  si->tempo = 60;
  si->start = 0;
  si->end = 0;
  si->stafftoplay = 0;

  si->savebuffer = NULL;
  si->bookmarks = NULL;

  si->headerinfo = new_mudela_header ();

  si->filename = g_string_new ("");
  si->autosavename = g_string_new (dir);
  si->autosavename = g_string_append (si->autosavename, "/autosave.denemo");

  si->curlilynode = 0;	 /* the node of the lily parse tree on display in 
			    textwindow */
  si->lily_file = 0;   /* root of lily file parse, see lilyparser.y etc  */
  si->sconfig = new_score_config (lilyversion);
  /* Undo/redo initialisation */
  si->undodata = g_queue_new ();
  si->redodata = g_queue_new ();
  si->undo_redo_mode = UNDO;
}


/**
 * removes the data from the current scoreinfo stucture 
 * and reinitialises it
 * @param si pointer to the scoreinfo structure to initialise
 */
void
free_score (DenemoScore * si)
{
  gint final = (gint) (g_list_length (si->thescore));
/*  if (si->lily_file != NULL)
  abandon_lily_tree (si);*/
  for (; final == 0; --final)
    {
      si->currentstaffnum = final;
      si->currentstaff = g_list_nth (si->thescore, final - 1);
      removestaff (si, final, 1);
    }
  /*g_string_free (si->title, FALSE);
     g_string_free (si->subtitle, FALSE);
     g_string_free (si->composer, FALSE);
     g_string_free (si->filename, FALSE); */
  /* what's up with this ? dlp wants to know... */

  g_free (si->sconfig);
  free_lilypond_header(si->headerinfo);
  g_free (si->headerinfo);
  si->headerinfo=NULL;
  g_queue_free (si->undodata);
  g_queue_free (si->redodata);
  init_score (si, NULL);
}

/**
 * Destroy the lilypond mode text view of the score
 */
void
abandon_lily_tree (DenemoGUI * gui)
{

  if (gui->textwindow)
    gtk_widget_destroy (gui->textwindow);
  /* FIXME memory leak */
  gui->si->lily_file = NULL;
  gui->textwindow = NULL;
  gui->si->scoreblocks = NULL;	/* FIXME memory leak */
}

/**
 * Creates and initialises the mudela header struture
 * 
 * @return the newly created mudela_header structure
 */
LilypondHeaderInfo *
new_mudela_header ()
{
  LilypondHeaderInfo *head=NULL;

  head = (LilypondHeaderInfo *) g_malloc0 (sizeof (LilypondHeaderInfo));

  /* Header info */
  head->title = g_string_new ("");
  head->subtitle = g_string_new ("");
  head->poet = g_string_new ("");
  head->composer = g_string_new ("");
  head->meter = g_string_new ("");
  head->opus = g_string_new ("");
  head->arranger = g_string_new ("");
  head->instrument = g_string_new ("");
  head->dedication = g_string_new ("");
  head->piece = g_string_new ("");
  head->head = g_string_new ("");
  head->copyright = g_string_new ("");
  head->footer = g_string_new ("");
  head->tagline = g_string_new ("");
/*  head-> = g_string_new (""); */

  return head;

}

void free_lilypond_header(LilypondHeaderInfo *head)
{
  g_string_free(head->title, TRUE);
  g_string_free(head->subtitle, TRUE);
  g_string_free(head->poet, TRUE);
  g_string_free(head->composer, TRUE);
  g_string_free(head->meter, TRUE);
  g_string_free(head->opus, TRUE);
  g_string_free(head->arranger, TRUE);
  g_string_free(head->instrument, TRUE);
  g_string_free(head->dedication, TRUE);
  g_string_free(head->copyright, TRUE);
  g_string_free(head->footer, TRUE);
  g_string_free(head->tagline, TRUE);
  
}

/**
 * Create and initialise the score config struture
 *
 * @return the newly created score config structure
 */
DenemoScoreConfig *
new_score_config (gchar * lilyversion)
{
  DenemoScoreConfig *config =
    (DenemoScoreConfig *) g_malloc0 (sizeof (DenemoScoreConfig));

  config->papersize = g_string_new ("a4");	//A4 default
  config->fontsize = 16;
  config->lilyversion = g_string_new (lilyversion);
  config->orientation = TRUE;	//portrait

  return config;
}
