"""testing desktopcouch/local_files.py module"""

import testtools
from desktopcouch.tests import xdg_cache
import desktopcouch

class TestLocalFiles(testtools.TestCase):
    """Testing that local files returns the right things"""
    def test_all_files_returned(self):
        "Does local_files list all the files that it needs to?"
        import desktopcouch.local_files
        for required in [
                "FILE_LOG", "FILE_INI", "FILE_PID", "FILE_STDOUT",
                "FILE_STDERR", "DIR_DB", "COUCH_EXE", "COUCH_EXEC_COMMAND"]:
            self.assertTrue(required in dir(desktopcouch.local_files))

    def test_xdg_overwrite_works(self):
        # this should really check that it's in os.environ["TMP"]
        self.assertTrue(desktopcouch.local_files.FILE_INI.startswith("/tmp"))

    def test_couch_chain_ini_files(self):
        "Is compulsory-auth.ini picked up by the ini file finder?"
        import desktopcouch.local_files
        ok = [x for x in desktopcouch.local_files.couch_chain_ini_files().split()
              if x.endswith("compulsory-auth.ini")]
        self.assertTrue(len(ok) > 0)

