# Copyright 2010 Canonical Ltd.
#
# This file is part of desktopcouch.
#
# desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Manuel de la pena <manuel.delapena@canonical.com>
import testtools
from mocker import Mocker

import desktopcouch.tests as test_environment
from desktopcouch.pair.couchdb_pairing.ubuntuone_pairing import (
    pair_with_ubuntuone, U1_PAIR_RECORD, MAP_JS)

class TestUbuntonePairing(testtools.TestCase):

    def setUp(self):
        """setup each test"""
        super(TestUbuntonePairing, self).setUp()
        # set a number of mocks that are used in all tests
        self.mocker = Mocker()
        self.couchdb = self.mocker.mock()
        self.put_static_paired_service = self.mocker.replace(
            'desktopcouch.pair.couchdb_pairing.couchdb_io.' + 
            'put_static_paired_service')
        
    def test_pair_with_ubuntuone_no_view(self):
        """Tests that when the view is not present it is indeed created."""
        self.couchdb.view_exists(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result(False)
        # we are interested in the fact that the view is created
        self.couchdb.add_view(U1_PAIR_RECORD, MAP_JS, None, U1_PAIR_RECORD)
        # added to esure that the method carries on normally
        self.couchdb.execute_view(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result([])
        self.put_static_paired_service(None, "ubuntuone")
        self.mocker.replay()
        pair_with_ubuntuone(self.couchdb)
        self.mocker.verify()
        

    def test_pair_with_ubuntuone_no_record(self):
        """Ensure pairing is not done when there are no records ."""
        # execute the steps when no records are returned by the view
        self.couchdb.view_exists(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result(True)
        self.couchdb.execute_view(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result([])
        self.put_static_paired_service(None, "ubuntuone")
        self.mocker.replay()
        pair_with_ubuntuone(self.couchdb)
        self.mocker.verify()

    def test_pair_with_ubuntuone_user_deleted_record(self):
        """Ensure pairing is not done when the user explicitly removed it."""
        # create a mock object that will be the result from the view
        row = self.mocker.mock()
        # execute the steps to show that the user deleted the record
        self.couchdb.view_exists(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result(True)
        self.couchdb.execute_view(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result([row])
        row.value
        self.mocker.result(1)
        self.mocker.replay()
        pair_with_ubuntuone(self.couchdb)
        self.mocker.verify()

    def test_pair_with_ubuntuone_record_present(self):
        """Ensure pairing is not done when the record is already present."""
        # create a mock object that will be the result from the view
        row = self.mocker.mock()
        # execute the steps to show that the user deleted the record
        self.couchdb.view_exists(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result(True)
        self.couchdb.execute_view(U1_PAIR_RECORD, U1_PAIR_RECORD)
        self.mocker.result([row])
        row.value
        self.mocker.result(0)
        self.mocker.replay()
        pair_with_ubuntuone(self.couchdb)
        self.mocker.verify()
