# Copyright 2010 Canonical Ltd.
#
# This file is part of desktopcouch-tasks.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Rodrigo Moya <rodrigo.moya@canonical.com>

"""Tests for the Tasks record classes"""

import testtools

from desktopcouch.tasks import record as task_mod

class TestTaskRecord(testtools.TestCase):
    """Test the Task Record object."""

    def test_task_record(self):
        """Test that we get the correct record type."""
        task = task_mod.Task()
        self.assertEqual(task_mod.TASK_RECORD_TYPE, task.record_type)
        for field_name in task_mod.FIELD_NAMES:
            setattr(task, field_name, 'value')
            self.assertEqual('value', task._data[field_name])
            self.assertEqual(getattr(task, field_name), 'value')

        # Check all keys
        all_keys = set(task_mod.FIELD_NAMES)
        all_keys.add('record_type')
        self.assertEqual(set(task.keys()), all_keys)
