"""Tests for Desktop CouchDB"""

import atexit
import os
import unittest
import tempfile
import shutil


from desktopcouch.application import local_files
from desktopcouch.application.platform import (TestKeyring,
    set_application_name)
from desktopcouch.application.start_local_couchdb import start_couchdb
from desktopcouch.application.stop_local_couchdb import stop_couchdb

set_application_name('desktopcouch testing')


class TestCase(unittest.TestCase):
    """Base class for tests."""

    def __init__(self, *args, **kwargs):
        super(TestCase, self).__init__(*args, **kwargs)
        # pylint: disable=C0103
        if not hasattr(self, 'assertIn'):
            self.assertIn = lambda value, container, *args: \
                            self.assertTrue(value in container, *args)
        if not hasattr(self, 'assertNotIn'):
            self.assertNotIn = lambda value, container, *args: \
                               self.assertTrue(value not in container, *args)
        if not hasattr(self, 'assertIs'):
            self.assertIs = lambda value1, value2, *args: \
                            self.assertTrue(value1 is value2, *args)
        if not hasattr(self, 'assertIsNot'):
            self.assertIsNot = lambda value1, value2, *args: \
                               self.assertTrue(value1 is not value2, *args)


def create_new_test_environment():
    """Create a new test environment."""
    basedir = tempfile.mkdtemp()
    if not os.path.exists(basedir):
        os.mkdir(basedir)

    cache = os.path.join(basedir, 'cache')
    data = os.path.join(basedir, 'data')
    config = os.path.join(basedir, 'config')
    new_context = local_files.Context(
        cache, data, config, keyring=TestKeyring())
    new_context.couchdb_log_level = 'debug'

    # Add etc folder to config
    source_tree_etc_folder = os.path.realpath(
      os.path.join(os.path.split(__file__)[0], "..", "..", "config"))
    if os.path.isdir(source_tree_etc_folder):
        os.environ["XDG_CONFIG_DIRS"] = source_tree_etc_folder

    def stop_test_couch(temp_dir, ctx):
        """Stop the test couchdatabase."""
        stop_couchdb(ctx)
        shutil.rmtree(temp_dir)

    start_couchdb(ctx=new_context)
    atexit.register(stop_test_couch, basedir, new_context)

    return new_context


# TODO: Remove these after you're sure nothing we care about uses these env.
os.environ['XDG_CACHE_HOME'] = "/cachehome"
os.environ['XDG_DATA_HOME'] = "/datahome"
os.environ['XDG_CONFIG_HOME'] = "/confighome"
os.environ['XDG_DATA_DIRS'] = ''

test_context = create_new_test_environment()  # pylint: disable=C0103
