# Copyright 2010 Canonical Ltd.
#
# This file is part of desktopcouch-bookmarks.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Zachery Bir <zachery.bir@canonical.com>
#          Joshua Blount <joshua.blount@canonical.com>

"""Tests for the Bookmarks record classes"""

from unittest import TestCase

from desktopcouch.recordtypes.bookmarks import (
    Bookmark, BOOKMARK_RECORD_TYPE, Folder, FOLDER_RECORD_TYPE, Separator,
    SEPARATOR_RECORD_TYPE, Feed, FEED_RECORD_TYPE)


class TestBookmarkRecord(TestCase):
    """Test the Bookmark Record object."""

    def test_bookmark_record(self):
        """Test that we get the correct record type."""
        bookmark = Bookmark()
        self.assertEqual(BOOKMARK_RECORD_TYPE, bookmark.record_type)


class TestFolderRecord(TestCase):
    """Test the Folder Record object."""

    def test_folder_record(self):
        """Test that we get the correct record type."""
        folder = Folder()
        self.assertEqual(FOLDER_RECORD_TYPE, folder.record_type)


class TestSeparatorRecord(TestCase):
    """Test the Separator Record object."""

    def test_separator_record(self):
        """Test that we get the correct record type."""
        separator = Separator()
        self.assertEqual(SEPARATOR_RECORD_TYPE, separator.record_type)


class TestFeedRecord(TestCase):
    """Test the Feed Record object."""

    def test_feed_record(self):
        """Test that we get the correct record type."""
        feed = Feed()
        self.assertEqual(FEED_RECORD_TYPE, feed.record_type)
