#  DHCP D-BUS Daemon 
#
%{?!DHCDBD_SETUID:%define DHCDBD_SETUID	0}
#
#  If dhcdbd is to be run by the dbus-daemon's service activation service,
#  then currently it MUST be installed setuid; else, it must have an 
#  initscript and be run as root during boot .
#
Summary:   DHCP D-BUS daemon (dhcdbd) controls dhclient sessions with D-BUS, stores and presents DHCP options.
Name: 	   dhcdbd
Version:   1.10
Release:   1.FC5
License:   GPL
Group:     System Environment/Daemons
URL: 	   http://people.redhat.com/~jvdias/%{name}/%{name}-%{version}.tar.gz
Source0:   %{name}-%{version}.tar.gz
Source1:   dhcdbd.init
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires:  dhclient >= 3.0.2-12, dbus >= 0.33
BuildRequires: dbus-devel >= 0.33

%description

%prep
%setup -q
cp -fp %SOURCE1 RedHat/
# Copy latest .spec file to RedHat source dir so that up-to-date %doc/CHANGES can be generated
if [ -e %{_specdir}/%{name}.spec ]; then
# looks like beehive build. dhcdbd.spec is in %{_specdir}, not %{_srcdir} 
  cp -fp %{_specdir}/%{name}.spec RedHat/;
else
# looks like Makefile build. dhcdbd.spec is in %{_builddir} 
  cp -fp %{_builddir}/%{name}.spec RedHat/;
fi;

%build
%ifarch s390x x86_64 ppc64
# every 64-bit arch EXCEPT ia64 has dbus arch. dep. includes in 
# /usr/lib64/dbus-1.0/include
export LIBDIR=lib64
%endif
CFLAGS="-Wall $RPM_OPT_FLAGS" CC='gcc' make

%install
DESTDIR=$RPM_BUILD_ROOT make install
%if ! %{DHCDBD_SETUID}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -c -m 755 %SOURCE1 $RPM_BUILD_ROOT/etc/rc.d/init.d/dhcdbd
%endif

%post
if [ $1 -eq 1 ]; then
   chkconfig --add dhcdbd >/dev/null 2>&1;
fi

%preun
if [ $1 -eq 0 ]; then
   service dhcdbd stop;
fi

%postun
if [ $1 -ge 1 ]; then
   service dhcdbd condrestart;
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%config /usr/share/dbus-1/services/dhcdbd.service
%config /etc/dbus-1/system.d/dhcdbd.conf
%if %{DHCDBD_SETUID}
%attr(6755,root,root) /sbin/dhcdbd
%else
%attr(755,root,root) /sbin/dhcdbd
%attr(755,root,root) /etc/rc.d/init.d/dhcdbd
%endif
%doc README LICENSE CHANGES dhcp_options.h dhcdbd.h dbus_service.h

%changelog
* Wed Nov 16 2005 Jason Vas Dias <jvdias@redhat.com> 1.10-1
- Rebuild for FC-5 (version must compare > FC-4)
- Change dhclient.leases directory for bug 169164
 
* Thu Oct 06 2005 Jason Vas Dias <jvdias@redhat.com> 1.9-1
- fix bug 169937: do 'chkconfig --add dhcdbd' in %post 
- Add CHANGES changelog file to %doc generated from this changelog
- Rebuild with new dbus / gcc / glibc

* Fri Aug 12 2005 Jason Vas Dias <jvdias@redhat.com> 1.8-1
- Allow named user permission to send in /etc/dbus-1/system.d/dhcdbd.conf
- Fix bug 163711 addendum: handle non-existence of /etc/sysconfig/network

* Wed Jul 27 2005 Jason Vas Dias <jvdias@redhat.com> 1.7-1
- fix bug 163711 / 162857: dhcdbd.init startup order
- improve security with system.d/dhcdbd.conf: allow only
  root user to send to dhcdbd
 
* Mon Jun 06 2005 Jason Vas Dias <jvdias@redhat.com> 1.6-1
- Add GPL licensing
- Make all paths into -D options
- Handle interface specific dhclient-${if}.conf files properly
- Add "up" dhclient flag DHCLIENT_NO_LEASES to remove
  lease database on startup
- Add /var/run/dhcdbd.pid file support
- fix initscript stop & add condrestart
- invoke condrestart on upgrade
- cleanup after dead prospective subscribers properly

* Sun May 15 2005 Jason Vas Dias <jvdias@redhat.com> 1.5-1
- add subscriptions for option signals from ANY interface
- fix handling of .old. options from previous lease

* Tue May 03 2005 Jason Vas Dias <jvdias@redhat.com> 1.4-1
- continue to ship dhcdbd.conf and dhcdbd.service even if
  DHCDBD_SETUID=0
- allow --no_daemon to appear before --system or --session

* Tue May 03 2005 Jason Vas Dias <jvdias@redhat.com> 1.3-1
- added timeout "up" argument

* Mon May 02 2005 Jason Vas Dias <jvdias@redhat.com> 1.2-1
- removed setuid requirement.

* Fri Apr 30 2005 Jason Vas Dias <jvdias@redhat.com> 1.1-1
- added subscription facility.

* Mon Apr 25 2005 Jason Vas Dias <jvdias@redhat.com> - 
- Initial build.



