# -*- coding: utf-8 -*-
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
""""dirspec tests."""

from twisted.trial.unittest import TestCase


class BaseTestCase(TestCase):
    """Base test case for dirspect tests."""

    def assert_utf8_bytes(self, value):
        """Check that 'value' is a bytes sequence encoded with utf-8."""
        self.assertIsInstance(value, str)
        try:
            value.decode('utf-8')
        except UnicodeDecodeError:
            self.fail('%r should be a utf8 encoded string.' % value)
