<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: lists.xsl,v 1.7 2003/05/24 19:16:53 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.

     ******************************************************************** -->

<xsl:template name="list.block">
  <xsl:param name="content">
    <xsl:apply-templates />
  </xsl:param>

  <xsl:choose>
    <xsl:when test="ancestor::itemizedlist | ancestor::orderedlist | ancestor::variablelist">
      <indent>
        <xsl:copy-of select="$content" />
      </indent>
    </xsl:when>

    <xsl:otherwise>
      <xsl:copy-of select="$content" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="itemizedlist">
  <xsl:call-template name="list.block" />
</xsl:template>

<xsl:template match="itemizedlist/listitem">
  <TP indent="0.2i">
    <TPtag>&#x2022;</TPtag> <!-- i18n FIXME -->
    <TPitem>
      <xsl:apply-templates />
    </TPitem>
  </TP>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="orderedlist">
  <xsl:call-template name="list.block" />
</xsl:template>

<xsl:template match="orderedlist/listitem">
  <TP>
    <TPtag><xsl:number /><xsl:text>.</xsl:text></TPtag>
    <TPitem><xsl:apply-templates /></TPitem>
  </TP>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="variablelist">
  <xsl:call-template name="list.block" />
</xsl:template>

<xsl:template match="varlistentry">
  <TP>
    <TPtag>
      <xsl:apply-templates select="term" />
    </TPtag>

    <xsl:apply-templates select="listitem" />
  </TP>
</xsl:template>

<xsl:template match="term[1]">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="term">
  <xsl:call-template name="gentext-text">
    <xsl:with-param name="key" select="'inline-list-separator'" />
  </xsl:call-template>
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="varlistentry/listitem">
  <TPitem><xsl:apply-templates /></TPitem>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="simplelist">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="member">
  <para>
    <xsl:apply-templates/>
  </para>
</xsl:template>
<xsl:template match="member[1]" priority="1">
  <para>
    <xsl:apply-templates/>
  </para>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="simplelist[@type='inline']">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="simplelist[@type='inline']/member">
  <xsl:call-template name="gentext-text">
    <xsl:with-param name="key" select="'inline-list-separator'" />
  </xsl:call-template>
  <xsl:apply-templates />
</xsl:template>
<xsl:template match="simplelist[@type='inline']/member[1]" priority="1">
  <xsl:apply-templates />
</xsl:template>

</xsl:stylesheet>

