/* $Id: hierbox.h,v 1.51 2004/01/04 20:18:56 jonas Exp $ */

#ifndef EL__BFU_HIERBOX_H
#define EL__BFU_HIERBOX_H

#include "bfu/dialog.h"
#include "bfu/listbox.h"
#include "bfu/widget.h"
#include "util/lists.h"

struct session;


typedef int (*hierbox_button_handler)(struct dialog_data *dlg_data, struct widget_data *button);

struct hierbox_browser_button {
	unsigned char *label;
	hierbox_button_handler handler;

	/* Should the button be displayed in anonymous mode */
	unsigned int anonymous:1;
};

#define HIERBOX_BROWSER_BUTTONS_SIZE(buttons) \
	(sizeof(buttons) / sizeof(struct hierbox_browser_button))

struct hierbox_browser {
	unsigned char *title;
	struct hierbox_browser_button *buttons;
	size_t buttons_size;

	struct list_head boxes;
	struct list_head dialogs;
	struct listbox_item root;
	struct listbox_ops *ops;

	/* For saving state */
	struct listbox_data box_data;
};

#define struct_hierbox_browser(name, title, buttons, ops)	\
	struct hierbox_browser name = {					\
		title,							\
		buttons,						\
		HIERBOX_BROWSER_BUTTONS_SIZE(buttons),			\
		{ D_LIST_HEAD(name.boxes) },				\
		{ D_LIST_HEAD(name.dialogs) },				\
		{							\
			NULL_LIST_HEAD,					\
			NULL,						\
			{ D_LIST_HEAD(name.root.child) },		\
			BI_FOLDER,					\
			-1,						\
			1,						\
			0,						\
		},							\
		ops,							\
	}

void done_listbox_item(struct hierbox_browser *browser, struct listbox_item *box);
void update_hierbox_browser(struct hierbox_browser *browser);

struct listbox_item *
do_add_listbox_item(struct listbox_item *root, unsigned char *text, void *data,
		    int no_empty, enum listbox_item_type type);

static inline struct listbox_item *
add_listbox_item(struct hierbox_browser *browser, unsigned char *text, void *data)
{
	struct listbox_item *item;

	item = do_add_listbox_item(&browser->root, text, data, 0, BI_LEAF);
	update_hierbox_browser(browser);
	return item;
}

struct listbox_item *
add_listbox_items(struct hierbox_browser *browser, void *data, int noempty,
		  unsigned char *text, ...);

/* We use hierarchic listbox browsers for the various managers. They consist
 * of a listbox widget and some buttons.
 *
 * @term	The terminal where the browser should appear.
 *
 * @title	The title of the browser. It is automatically localized.
 *
 * @add_size	The size of extra data to be allocated with the dialog.
 *
 * @browser	The browser structure that contains info to setup listbox data
 *		and manage the dialog list to keep instances of the browser in
 *		sync on various terminals.
 *
 * @udata	Is a reference to any data that the dialog could use.
 *
 * @buttons	Denotes the number of buttons given as varadic arguments.
 *		For each button 4 arguments are extracted:
 *			o First the label text. It is automatically localized.
 *			  If NULL, this button is skipped.
 *			o Second a pointer to a widget handler.
 *		XXX: A close button will be installed by default.
 *
 * XXX: Note that the @listbox_data is detached and freed by the dialog handler.
 *	Any other requirements should be handled by installing a specific
 *	dlg->abort handler. */

struct dialog_data *
hierbox_browser(struct hierbox_browser *browser, struct session *ses);

int push_hierbox_info_button(struct dialog_data *dlg_data, struct widget_data *button);
int push_hierbox_goto_button(struct dialog_data *dlg_data, struct widget_data *button);
int push_hierbox_delete_button(struct dialog_data *dlg_data, struct widget_data *button);
int push_hierbox_clear_button(struct dialog_data *dlg_data, struct widget_data *button);

#endif
