# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'


from elisa.base_components.view import View

import pygtk
pygtk.require('2.0')
import gtk


class GtkStartupView(View):
    """
    This class implements gtk list view support
    """

    supported_controllers = ('base:elisa_controller', )
    bindings = (('menu', 'menu'),
                ('player', 'player'))

    def __init__(self):
        View.__init__(self)
        self.context_path = 'gtk:gtk_context'
        self.box = gtk.VBox()
        self.context_handle = self.box

    def controller_changed(self, old_controller, new_controller):
        scrolled_treeview = gtk.ScrolledWindow()
        scrolled_treeview.add(self.menu.treeview)
        self.box.pack_start_defaults(scrolled_treeview)
        self.box.pack_end(self.player.vbox, False, False, 0)

    def save_config(self, app_config):
        View.save_config(self, app_config)
        self.menu.save_config(app_config)
        self.player.save_config(app_config)
