# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core import common

plugin_registry = common.application.plugin_registry
PigmentView = plugin_registry.get_component_class('pigment:pigment_view')
BaseListView = plugin_registry.get_component_class('raval:list_view')

class ManagerView(PigmentView):

    supported_controllers = ('raval:manager_controller',)

    current = None

    bindings = (('location', 'location'),
                ('context', 'context'),
                ('context_visible', 'context_visible'),
                ('context_active', 'context_active'))

    def attribute_set(self, origin, key, old_value, new_value):
        PigmentView.attribute_set(self, origin, key, old_value, new_value)

        if key == "current":
            self.create_view(new_value)
        elif key == "loading":
            if isinstance(self.current , BaseListView):
                self.current.loading = new_value 

    def context_visible__set(self, value):
        if value:
            self.context.show()
        else:
            self.context.hide()

    def context_active__set(self, value):
        if hasattr(self, 'context') and self.context is not None:
            self.context.active = value

    def create_view(self, controller):
        self.debug("Creating view for %r (current view=%r)", controller,
                   self.current)

        # removing the old view
        if self.current != None:
            def remove_old_view(old_view):
                old_view.clean()

            old_view = self.current
            fadeout = plugin_registry.create_component('pigment:fadeout_transition')
            fadeout.apply(old_view, lambda: remove_old_view(old_view))

            # disconnect the view from its controller
            old_view.controller = None

        else:
            old_view = None

        # create a corresponding view
        model_path = controller.model.path

        content_type = getattr(controller.model, 'content_type', None)
        view_path = self.frontend.get_view_path(model_path,
                                                content_type=content_type)
        # FIXME: calling a private method
        self._create_child_view("current", view_path)

        fadein = plugin_registry.create_component('pigment:fadein_transition')
        fadein.apply(self.current)

        # ... and link it to the controller
        self.current.controller = controller

        self.debug("Switched betweeen %r and %r", old_view, self.current)

    def controller_changed(self, old_controller, new_controller):
        self.create_view(new_controller.current)

    def _memory_usage_tests(self):
        import pgm, gc
        from elisa.core.component import Component 
        gc.collect()

        #display layer counts in pigment
        canvas = self.frontend.context.viewport_handle.get_canvas()
        print "canvas layer count = ", canvas.get_layer_count(pgm.DRAWABLE_FAR), canvas.get_layer_count(pgm.DRAWABLE_MIDDLE), canvas.get_layer_count(pgm.DRAWABLE_NEAR)

        #display in python object referenced for Image and component
        from pgm.widgets.scrollbar import Scrollbar
        from  shaded_list_view import ShadedListView
        img = []
        comp = []
        f = gc.get_objects()
        for o in f:
            if isinstance(o, pgm.Image):
                img.append(o)
            if isinstance(o, Component):
                comp.append(o)

        print "python ref: img=%s, comp=%s" % (len(img), len(comp) )

        #print all the objects with more than 100 instances
        """
        from elisa.plugins.bad.helper_frontend.report_tools import ReportTools
        r = ReportTools()
        ii = r.get_instance_infos(min_count = 100)
        for inst in ii.keys():
            print "%s inst = %s, count= %s" % ( ii[inst][0], inst, ii[inst][0])
        print "---------------------------------------------"
        """
