# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import pgm
from pgm.graph.group import Group
from pgm.graph.image import Image
from pgm.graph.text import Text

class MiniPlayer(Group):

    def __init__(self, background=None, play_icon=None, pause_icon=None):
        Group.__init__(self)
        
        self._background = Image()
        self._background.layout = pgm.IMAGE_SCALED
        #self._background.interp = pgm.IMAGE_NEAREST
        self.background.bg_color = (0, 0, 0, 0)

        self._play_icon = Image()
        self._play_icon.layout = pgm.IMAGE_SCALED
        self._play_icon.bg_color = (0, 0, 0, 0)
        self._play_icon.connect("clicked", self.play_clicked)
        
        self._pause_icon = Image()
        self._pause_icon.layout = pgm.IMAGE_SCALED
        self._pause_icon.bg_color = (0, 0, 0, 0)
        self._pause_icon.connect("clicked", self.pause_clicked)
        
        self.add(self._background)
        self.add(self._play_icon)
        self.add(self._pause_icon)
                 
        self.background = background
        self.play_icon = play_icon
        self.pause_icon = pause_icon

    def pause_clicked(self, widget, x, y, z, time, button_type):
        pass

    def play_clicked(self, widget, x, y, z, time, button_type):
        pass
        
    def background__set(self, background_file):
        if background_file:
            self._background.set_from_file(background_file)

    def background__get(self):
        return self._background

    def play_icon__set(self, icon_file):
        if icon_file:
            self._play_icon.set_from_file(icon_file)
            
    def play_icon__get(self):
        return self._play_icon

    def pause_icon__set(self, icon_file):
        if icon_file:
            self._pause_icon.set_from_file(icon_file)
            
    def pause_icon__get(self):
        return self._pause_icon

    def bg_color__set(self, color):
        self.pause_icon.bg_color = color
        self.play_icon.bg_color = color

    def border_width__set(self, value):
        self.pause_icon.border_width = value
        self.play_icon.border_width = value

    def border_inner_color__set(self, color):
        self.pause_icon.border_inner_color = color
        self.play_icon.border_inner_color = color

    def border_outer_color__set(self, color):
        self.pause_icon.border_outer_color = color
        self.play_icon.border_outer_color = color

    

if __name__ == "__main__":
    import os
    import gobject
    import gst
    from pgm.timing import implicit
    from pgm.graph.text import Text


    def on_key_press(viewport, event, widget):
        # quit on q or ESC
        if event.keyval in (pgm.keysyms.q, pgm.keysyms.Escape):
            pgm.main_quit()
        elif event.keyval == pgm.keysyms.t:
            widget.play_icon.visible = not widget.play_icon.visible
            widget.pause_icon.visible = not widget.pause_icon.visible
            
    def on_delete(viewport, event):
        pgm.main_quit()
        
    # OpenGL viewport creation
    factory = pgm.ViewportFactory('opengl')
    gl = factory.create()
    gl.title = 'Context bar widget'

    # Canvas and image drawable creation
    canvas = pgm.Canvas()
    
    # Bind the canvas to the OpenGL viewport
    gl.set_canvas(canvas)
    gl.show()
    
    player = MiniPlayer()
    #context.icon = "../poblenou_frontend/tango_theme/music.png"
    player.canvas = canvas    
    player.position = (0.0, 0.0, 0.0)
    player.width = canvas.width / 20.
    player.height = 0.2
    player.visible = True
    
    #player.background = "theme/context_bar_bg.png"
    player.play_icon = "theme/mini_player_play.png"
    player.pause_icon = "theme/mini_player_pause.png"

    player.play_icon.visible = True
    player.pause_icon.visible = False
    
    # Let's start a mainloop
    gl.connect('key-press-event', on_key_press, player)
    gl.connect('delete-event', on_delete)
    pgm.main()
    
