# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

"""
A simple import and initialize test for the base models.
"""

from elisa.plugins.base.models import audio, video, image, media, network

from twisted.trial.unittest import TestCase


class ModelMixin(object):

    module = None

    def test_import_and_initialize(self):
        models = filter(lambda x: x.endswith('Model'), dir(self.module))
        for model_name in models:
            model_class = getattr(self.module, model_name)
            obj = model_class()


class TestAudioModels(TestCase, ModelMixin):

    module = audio


class TestVideoModels(TestCase, ModelMixin):

    module = video


class TestImageModels(TestCase, ModelMixin):

    module = image


class TestMediaModels(TestCase, ModelMixin):

    module = media

class TestNetworkModels(TestCase, ModelMixin):

    module = network
