import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-weather',
    version='0.1', 
    description='Weather plugin',
    license='GPL3', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    install_requires=['pymetar>=0.12'],
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png', '*.mo', '*.po']},
    controller_mappings=[('/elisa/weather',
            'elisa.plugins.weather.weather_controller:WeatherController')],
    cmdclass=cmdclass)
