// Install script for Enigmime

var err;

err = initInstall("Enigmime v0.90.2", // name for install UI
                  "/enigmime",         // registered name
                  "0.90.2.0");        // package version

logComment("initInstall: " + err);

var srDest = 500;       // Disk space required for installation (KB)

var fProgram    = getFolder("Program");
logComment("fProgram: " + fProgram);

if (!verifyDiskSpace(fProgram, srDest)) {
  cancelInstall(INSUFFICIENT_DISK_SPACE);

} else {

  var fComponents = getFolder("Components");
  var fChrome = getFolder("Chrome");

  // workaround for Mozilla 1.8a3 and newer, failing to register enigmime correctly
  
  var delComps = [ "compreg.dat" ]; // Components registry

  for (var j=0; j<delComps.length; j++) {
     var delFile = getFolder(fComponents, delComps[j]);
     if (File.exists(delFile))
        File.remove(delFile);
  }

  // addDirectory: blank, archive_dir, install_dir, install_subdir
  addDirectory("", "chrome", fChrome, "");
  addDirectory("", "components", fComponents, "");

  err = getLastError();

  if (err == ACCESS_DENIED) {
    alert("Unable to write to components directory "+fComponents+".\n You will need to restart the browser with administrator/root privileges to install this software. After installing as root (or administrator), you will need to restart the browser one more time to register the installed software.\n After the second restart, you can go back to running the browser without privileges!");

    cancelInstall(ACCESS_DENIED);

  } else if (err != SUCCESS) {
    cancelInstall(err);

  } else {
    // register Chrome
    registerChrome(PACKAGE | DELAYED_CHROME, getFolder("Chrome","enigmime.jar"), "content/enigmime/");
    performInstall();
  }
}

// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired) {
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired) {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return false;
  }

  return true;
}

// OS type detection
// which platform?
function getPlatform() {
  var platformStr;
  var platformNode;

  if('platform' in Install) {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}
