/** -*- C++ -*-
	@file libept/quickfilter.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <apt-front/cache/entity/entity.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/cache/component/tags.h>
#include <apt-front/predicate/factory.h>
#include <libept/easytagfilterui.h>
#include <libept/filterlist.h>
#include <libept/lister.h>
#include <qlayout.h>
#include <kdebug.h>

#ifndef EPT_EASYTAGFILTER_H
#define EPT_EASYTAGFILTER_H

namespace ept {

template< typename T >
struct EasyTagFilter : predicate::Implementation< T, EasyTagFilter< T > >,
    InterfacingPredicate
{
    typedef std::map< std::string, std::string > Tags;

    EasyTagFilter() {
        setupPredicate();
    }

    void setupPredicate() {
        Cache &cache = cache::Global::get(); // FIXME?
        m_op = predicate::True< T >();
        TagFilter< entity::Package > t;
        for (Tags::iterator i = m_tags.begin();
             i != m_tags.end(); ++i ) {
            t.setTag( cache.tags().tagByName( i->first + "::" + i->second ) );
            m_op = m_op and t;
            kdDebug() << t.summary() << endl;
        }
    }

    std::string summary() const {
        std::string r( "EasyTag filter: " );
        for (Tags::const_iterator j, i = m_tags.begin();
             i != m_tags.end(); ++i ) {
            j = i; ++j;
            r += i->first + ": " + i->second;
            if (j != m_tags.end())
                r += ", ";
        }
        return r;
    }

    void parseArguments( const predicate::ArgumentList & ) {}

    bool operator==( const EasyTagFilter &o ) const {
        return o.m_tags == m_tags;
    }

    bool operator()( const T &p ) {
        return m_op( p );
    }

    void set( const std::string &f, const std::string &t ) {
        m_tags[f] = t;
        setupPredicate();
    }

    std::string get( const std::string &f ) {
        return m_tags[ f ];
    }

protected:
    Tags m_tags;
    predicate::Predicate< T > m_op;
};

class EasyTagFilterWidget : public EasyTagFilterUi
{
    Q_OBJECT
public:
    EasyTagFilterWidget( QWidget *parent, const char *name = 0 );
    virtual Predicate predicate();
public slots:
    void predicateChanged();
    void reset();
};

}

#endif
