#include <apt-pkg/error.h>
// #include <klistbox.h>
#include <qlabel.h>

#include <string>
#include <iostream>

#include "errordialog.h"

using namespace kapture;

                                                                    /* {{{ */
ErrorDialog::ErrorDialog (QWidget *parent, const char *name)
    : KDialogBase (parent, name, true, "Errors and Warnings", Close, Close)
{
    QScrollView *sv = new QScrollView (this);
    QLabel *l = new QLabel (sv -> viewport ());
    l -> setMinimumSize (QSize (300, 90));
    l -> setAlignment (Qt::AlignTop | Qt::AlignJustify);
    l -> setMargin (4);
    sv -> addChild (l);
    sv -> setResizePolicy (QScrollView::AutoOneFit);
    sv -> setMinimumSize (QSize (350, 100));
    setMainWidget (sv);
    string s;
    string m ("<qt>");
    while (! _error -> empty ()) {
        bool t = _error -> PopMessage (s);
        m . append (t ? "<b><font color=\"red\">ERROR:</font></b> " : "<b>WARNING:</b> ");
        m . append (s);
        m . append ("<br>\n");
    }
    m . append ("</qt>");
    l -> setText (m);
}
                                                                    /* }}} */
                                                                    /* {{{ */
ErrorDialog::~ErrorDialog ()
{
}
                                                                    /* }}} */

                                                                    /* {{{ */
void ErrorDialog::dumpErrors (QWidget *parent)
{
    if (_error -> empty ())
        return;
    std::cerr << "dumping errors..." << std::endl;
    ErrorDialog *d = new ErrorDialog (parent);
    d -> exec ();
    delete d; // ?
}
                                                                    /* }}} */

#include "errordialog.moc"
