#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <klocale.h>
#include <klineedit.h>
#include "filterwidget.h"

using namespace aptFront;
using namespace ept;

void FilterWidget::connectLister( Lister *l ) {
    connect( this, SIGNAL( drop( Lister::Predicate ) ),
             l, SLOT( interactiveDrop( Lister::Predicate ) ) );
    connect( this, SIGNAL( changed( Lister::Predicate ) ),
             l, SLOT( interactiveAnd( Lister::Predicate ) ) );
    connect( this, SIGNAL( apply( Lister::Predicate ) ),
             l, SLOT( baseAnd( Lister::Predicate ) ) );

}

void FilterWidget::changedInternal() {
    setEnabled( false );
    emit drop( m_old );
    emit changed( m_old = predicate() );
    setEnabled( true );
    setFocus();
}

void FilterWidget::applyInternal() {
    // check for emptiness?
    setEnabled( false );
    emit drop( m_old );
    emit apply( m_old = predicate() );
    reset();
    setEnabled( true );
    setFocus();
}
