#include <kapplication.h>
#include <kdebug.h>
#include <libept/progress.h>

using namespace ept;

Progress::Progress()
    : m_pbar( 0 ), m_sbar( 0 )
{}

void Progress::Update ()
{
    if (!m_sbar)
        return;
    if (!m_pbar) {
        if (Percent) {
            m_pbar = new KProgress( m_sbar );
            m_pbar->setMinimumWidth( 80 );
            m_pbar->setMaximumWidth( 120 );
            m_pbar->setTextEnabled( false );
            m_pbar->show();
            m_sbar->addWidget( m_pbar, 0, true );
            m_pbar->setTotalSteps( 100 );
        }
        MajorChange = true;
    }
    if (MajorChange) {
        m_sbar->message( (Op + "...").c_str() );
    }
    if (CheckChange (0.05) == false)
        return;
    kdDebug() << "Progress::Update()" << endl;
    if (m_pbar)
        m_pbar->setProgress( Percent );
    kapp->processEvents();
}

void Progress::Done ()
{
    kdDebug() << "Progress::Done()" << endl;
    if (m_sbar)
        m_sbar->clear();
    delete m_pbar;
    m_pbar = 0;
}

Progress::~Progress() {}
